/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.ServletUtils;
import com.newrelic.agent.util.TransactionUtils;
import java.text.MessageFormat;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class ServletInitPointCut
extends TracerFactoryPointCut {
    private static final String SERVLET_INTERFACE = "javax/servlet/Servlet";
    private static final String INIT_METHOD_NAME = "init";
    private static final String INIT_METHOD_DESC = "(Ljavax/servlet/ServletConfig;)V";

    public ServletInitPointCut(ClassTransformer classTransformer) {
        super(ServletInitPointCut.class, (ClassMatcher)new InterfaceMatcher(SERVLET_INTERFACE), ServletInitPointCut.createExactMethodMatcher(INIT_METHOD_NAME, INIT_METHOD_DESC));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object servlet, Object[] args) {
        try {
            Object servletContext = ServletUtils.getServletContextFromServletConfig(args[0]);
            TransactionUtils.setServerInfo(transaction, servletContext);
            TransactionUtils.setAppNameFromServletContext(transaction, servletContext);
            if (args.length != 1) {
                return null;
            }
            return new ServletInitTracer(this, transaction, sig, servlet);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", ServletInitPointCut.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else {
                Agent.LOG.finer(MessageFormat.format(msg, e));
            }
            return null;
        }
    }

    private static class ServletInitTracer
    extends OtherDispatcherTracer {
        public ServletInitTracer(PointCut pc, Transaction transaction, ClassMethodSignature sig, Object servlet) {
            super(transaction, sig, servlet, new SimpleMetricNameFormat("OtherTransaction/Initializer/ServletInit", ClassMethodMetricNameFormat.getMetricName(sig, servlet, "OtherTransaction/Initializer/ServletInit")));
        }

        protected void doFinish(int opcode, Object returnValue) {
            super.doFinish(opcode, returnValue);
            if (this.getParentTracer() == null && this.getChildren().isEmpty()) {
                this.getTransaction().setTraceDisabled(true);
            }
        }
    }
}

