/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.servlet;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;

@PointCut
public class ServletRequestPointCut
extends TracerFactoryPointCut {
    static final ClassMatcher SERVLET_REQUEST_CLASS_MATCHER = OrClassMatcher.getClassMatcher(new ExactClassMatcher("org/apache/catalina/connector/Request"), new ExactClassMatcher("org/mortbay/jetty/servlet/ServletHttpRequest"), new ExactClassMatcher("org/eclipse/jetty/server/Request"), new ExactClassMatcher("javax/servlet/ServletRequestWrapper"), new ExactClassMatcher("org/apache/struts/mock/MockHttpServletRequest"), new InterfaceMatcher("javax/servlet/ServletRequest"));

    public ServletRequestPointCut(ClassTransformer classTransformer) {
        super(ServletRequestPointCut.class, SERVLET_REQUEST_CLASS_MATCHER, ServletRequestPointCut.createExactMethodMatcher("setAttribute", "(Ljava/lang/String;Ljava/lang/Object;)V"));
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        String attributeName = (String)args[0];
        Object value = args[1];
        ServletRequestPointCut.noticeRequestAttributeSet(transaction, attributeName, value);
        return null;
    }

    public static void noticeRequestAttributeSet(Transaction transaction, String attributeName, Object value) {
        Tracer tracer;
        if ("com.newrelic.agent.IGNORE".equals(attributeName)) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                transaction.setIgnore(true);
            }
        } else if ("com.newrelic.agent.IGNORE_APDEX".equals(attributeName) && (tracer = transaction.getRootTracer()) instanceof RequestDispatcherTracer) {
            ((RequestDispatcherTracer)tracer).setIgnoreApdex(value instanceof Boolean && (Boolean)value != false);
        }
    }
}

