/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.solr;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.instrumentation.pointcuts.solr.AbstractSolrPointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PointCut
public class SolrRequestHandlerPointCut
extends AbstractSolrPointCut {
    private static SolrReflectionHelper sSolrReflectionHelper = null;

    public SolrRequestHandlerPointCut(ClassTransformer classTransformer) {
        super((Class<? extends AbstractSolrPointCut>)SolrRequestHandlerPointCut.class, OrClassMatcher.getClassMatcher(new ExactClassMatcher("org/apache/solr/handler/RequestHandlerBase"), new InterfaceMatcher("org/apache/solr/request/SolrRequestHandler")), SolrRequestHandlerPointCut.createExactMethodMatcher("handleRequest", "(Lorg/apache/solr/request/SolrQueryRequest;Lorg/apache/solr/request/SolrQueryResponse;)V"));
    }

    @Override
    public Tracer getTracer(final Transaction transaction, ClassMethodSignature sig, Object handler, Object[] args) {
        final String type = this.getQueryType(handler, args[0]);
        return new DefaultTracer(transaction, sig, handler, new ClassMethodMetricNameFormat(sig, handler, "SolrRequestHandler")){

            protected void doFinish(int opcode, Object returnValue) {
                super.doFinish(opcode, returnValue);
                Tracer rootTracer = transaction.getRootTracer();
                Object rb = this.getTransaction().getSolrCache().remove("solr_response_builder");
                if (rb != null) {
                    Map<String, String> result = SolrRequestHandlerPointCut.addDebugInfo(rb);
                    transaction.getParameters().putAll(result);
                }
                if (rootTracer instanceof RequestDispatcherTracer) {
                    String uri = ((RequestDispatcherTracer)rootTracer).getRequestURI();
                    StringBuilder builder = new StringBuilder("WebTransaction").append("/Solr").append(uri);
                    if (type != null) {
                        if (!uri.endsWith("/")) {
                            builder.append('/');
                        }
                        builder.append(type);
                    }
                    transaction.setNormalizedUri(builder.toString());
                }
            }
        };
    }

    static SolrReflectionHelper getSolrReflectionHelper(Object rb) throws Exception {
        if (sSolrReflectionHelper == null) {
            sSolrReflectionHelper = new SolrReflectionHelper(rb);
        }
        return sSolrReflectionHelper;
    }

    static Map<String, String> addDebugInfo(Object rb) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            SolrReflectionHelper helper = SolrRequestHandlerPointCut.getSolrReflectionHelper(rb);
            Object solrQueryRequest = helper.reqField.get(rb);
            Object solrParams = helper.getParamsMethod.invoke(solrQueryRequest, new Object[0]);
            String rawQueryString = (String)solrParams.getClass().getMethod("get", String.class).invoke(solrParams, "q");
            result.put("raw_query_string", rawQueryString);
            String queryString = (String)helper.getQueryString.invoke(rb, new Object[0]);
            result.put("query_string", queryString);
            Object schema = helper.getSchemaMethod.invoke(solrQueryRequest, new Object[0]);
            Object query = helper.getQuery.invoke(rb, new Object[0]);
            String parsedQuery = (String)helper.queryParsingClass.getMethod("toString", helper.queryClass, helper.indexSchemaClass).invoke(null, query, schema);
            result.put("lucene_query", parsedQuery);
            String parsedQueryToString = query.toString();
            result.put("lucene_query_string", parsedQueryToString);
        }
        catch (Throwable e) {
            result.put("solr_debug_info_error", e.toString());
            Agent.LOG.log(Level.FINER, "Error in Solr debug data collection - {0}", e.toString());
            Agent.LOG.log(Level.FINEST, "Error in Solr debug data collection", e);
        }
        return result;
    }

    private String getQueryType(Object handler, Object request) {
        try {
            Object queryType = request.getClass().getClassLoader().loadClass("org.apache.solr.request.SolrQueryRequest").getMethod("getQueryType", new Class[0]).invoke(request, new Object[0]);
            if (queryType != null) {
                return queryType.toString();
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.INFO, "Unable to get the SolrQueryRequest query type : {0}", e.toString());
            Agent.LOG.log(Level.FINER, "Unable to get the SolrQueryRequest query type", e);
        }
        return null;
    }

    private static class SolrReflectionHelper {
        public final Class<?> solrPluginUtilsClass;
        public final Class<?> solrQueryRequestClass;
        public final Class<?> docListClass;
        public final Class<?> queryClass;
        public final Class<?> queryParsingClass;
        public final Class<?> indexSchemaClass;
        public final Field reqField;
        public final Method getQueryString;
        public final Method getQuery;
        public final Method getResults;
        public final Method getParamsMethod;
        public final Method getSchemaMethod;

        public SolrReflectionHelper(Object rb) throws Exception {
            Class<?> responseBuilderClass = rb.getClass();
            ClassLoader cl = responseBuilderClass.getClassLoader();
            this.solrPluginUtilsClass = cl.loadClass("org.apache.solr.util.SolrPluginUtils");
            this.solrQueryRequestClass = cl.loadClass("org.apache.solr.request.SolrQueryRequest");
            this.docListClass = cl.loadClass("org.apache.solr.search.DocList");
            this.queryClass = cl.loadClass("org.apache.lucene.search.Query");
            this.queryParsingClass = cl.loadClass("org.apache.solr.search.QueryParsing");
            this.indexSchemaClass = cl.loadClass("org.apache.solr.schema.IndexSchema");
            this.reqField = responseBuilderClass.getDeclaredField("req");
            this.getQueryString = responseBuilderClass.getMethod("getQueryString", new Class[0]);
            this.getQuery = responseBuilderClass.getMethod("getQuery", new Class[0]);
            this.getResults = responseBuilderClass.getMethod("getResults", new Class[0]);
            this.getParamsMethod = this.solrQueryRequestClass.getMethod("getParams", new Class[0]);
            this.getSchemaMethod = this.solrQueryRequestClass.getMethod("getSchema", new Class[0]);
        }
    }
}

