/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.yaml;

import com.newrelic.agent.Agent;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.methodmatchers.ManyMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NoMethodsMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.StaticMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.ClassMethodNameFormatPointCut;
import com.newrelic.agent.instrumentation.yaml.InstrumentationConstructor;
import com.newrelic.agent.instrumentation.yaml.MetricNameFormatFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointCutFactory {
    private final String defaultMetricPrefix;

    public PointCutFactory(String metricPrefix) {
        this.defaultMetricPrefix = metricPrefix;
    }

    public Collection<PointCut> getPointCuts(Object config) throws ParseException {
        if (config instanceof List) {
            return this.getPointCuts((List)config);
        }
        if (config instanceof Map) {
            return this.getPointCuts((Map)config);
        }
        return Collections.EMPTY_LIST;
    }

    public PointCut getPointCut(Object obj) throws ParseException {
        if (obj instanceof String) {
            return this.getPointCut((String)obj);
        }
        if (obj instanceof Map) {
            return this.getPointCut((Map)obj);
        }
        throw new RuntimeException(MessageFormat.format("Unknown pointcut type: {0} ({1}", obj, obj.getClass().getName()));
    }

    public PointCut getPointCut(String string) throws ParseException {
        ClassMethodSignature sig = PointCutFactory.parseClassMethodSignature(string);
        if (sig != null) {
            ClassMethodNameFormatDescriptor format = new ClassMethodNameFormatDescriptor(this.defaultMetricPrefix, false);
            return new ClassMethodNameFormatPointCut(format, new ExactClassMatcher(sig.getClassName()), new InstanceMethodMatcher(PointCutFactory.createExactMethodMatcher(sig.getMethodName(), sig.getMethodDesc())), false, Collections.emptyMap());
        }
        throw new RuntimeException("Unable to parse point cut: " + string);
    }

    private PointCut getPointCut(Map attrs) {
        Object dispatcherProp;
        ClassMatcher classMatcher = PointCutFactory.getClassMatcher(attrs.get("class_matcher"));
        MethodMatcher methodMatcher = PointCutFactory.getMethodMatcher(attrs.get("method_matcher"));
        if (this.shouldAddInstanceMatcher(methodMatcher)) {
            methodMatcher = new InstanceMethodMatcher(methodMatcher);
        }
        boolean dispatcher = (dispatcherProp = attrs.get("dispatcher")) != null && Boolean.parseBoolean(dispatcherProp.toString());
        Object format = attrs.get("metric_name_format");
        if (format instanceof String) {
            format = new SimpleMetricNameFormatFactory(new SimpleMetricNameFormat(format.toString()));
        } else if (null == format) {
            format = new ClassMethodNameFormatDescriptor(this.defaultMetricPrefix, dispatcher);
        }
        if (format instanceof MetricNameFormatFactory) {
            return new ClassMethodNameFormatPointCut((MetricNameFormatFactory)format, classMatcher, methodMatcher, dispatcher, attrs);
        }
        throw new RuntimeException("Unsupported metric_name_format value");
    }

    private boolean shouldAddInstanceMatcher(MethodMatcher methodMatcher) {
        if (methodMatcher instanceof StaticMethodMatcher || methodMatcher instanceof InstanceMethodMatcher) {
            return false;
        }
        if (methodMatcher instanceof ManyMethodMatcher) {
            for (MethodMatcher matcher : ((ManyMethodMatcher)methodMatcher).getMethodMatchers()) {
                if (this.shouldAddInstanceMatcher(matcher)) continue;
                return false;
            }
        }
        return true;
    }

    public List<PointCut> getPointCuts(List list) throws ParseException {
        ArrayList<PointCut> pcs = new ArrayList<PointCut>();
        for (Object obj : list) {
            pcs.add(this.getPointCut(obj));
        }
        return pcs;
    }

    public List<PointCut> getPointCuts(Map namesToPointCuts) throws ParseException {
        Collection values = null;
        if (null != namesToPointCuts) {
            values = namesToPointCuts.values();
        }
        if (null == values) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PointCut> pcs = new ArrayList<PointCut>();
        for (Object obj : values) {
            if (obj instanceof String) {
                pcs.add(this.getPointCut((String)obj));
                continue;
            }
            if (!(obj instanceof Map)) continue;
            pcs.add(this.getPointCut((Map)obj));
        }
        return pcs;
    }

    static Collection<ClassMatcher> getClassMatchers(Collection matchers) {
        ArrayList<ClassMatcher> list = new ArrayList<ClassMatcher>(matchers.size());
        for (Object matcher : matchers) {
            list.add(PointCutFactory.getClassMatcher(matcher));
        }
        return list;
    }

    static ClassMatcher getClassMatcher(Object yaml) {
        if (yaml instanceof ClassMatcher) {
            return (ClassMatcher)yaml;
        }
        if (yaml instanceof String) {
            return new ExactClassMatcher(((String)yaml).trim());
        }
        if (yaml instanceof List) {
            List list = (List)yaml;
            return new OrClassMatcher(PointCutFactory.getClassMatchers(list));
        }
        return null;
    }

    static Collection<MethodMatcher> getMethodMatchers(Collection matchers) {
        ArrayList<MethodMatcher> list = new ArrayList<MethodMatcher>(matchers.size());
        for (Object matcher : matchers) {
            list.add(PointCutFactory.getMethodMatcher(matcher));
        }
        return list;
    }

    static MethodMatcher getMethodMatcher(Object yaml) {
        MethodMatcher matcher = null;
        if (yaml instanceof MethodMatcher) {
            matcher = (MethodMatcher)yaml;
        } else {
            String text;
            int index;
            if (yaml instanceof List) {
                List list = (List)yaml;
                if (!list.isEmpty() && list.get(0) instanceof String && list.get(0).toString().indexOf(40) < 0) {
                    return PointCutFactory.createExactMethodMatcher(list.get(0).toString().trim(), Strings.trim(list.subList(1, list.size())));
                }
                return new OrMethodMatcher(PointCutFactory.getMethodMatchers(list));
            }
            if (yaml instanceof String && (index = (text = yaml.toString().trim()).indexOf(40)) > 0) {
                String methodName = text.substring(0, index);
                String methodDesc = text.substring(index);
                return PointCutFactory.createExactMethodMatcher(methodName, methodDesc);
            }
        }
        return matcher;
    }

    public static ClassMethodSignature parseClassMethodSignature(String signature) {
        int methodArgIndex = signature.indexOf(40);
        if (methodArgIndex > 0) {
            String methodDesc = signature.substring(methodArgIndex);
            String classAndMethod = signature.substring(0, methodArgIndex);
            int methodStart = classAndMethod.lastIndexOf(46);
            if (methodStart > 0) {
                String methodName = classAndMethod.substring(methodStart + 1);
                String className = classAndMethod.substring(0, methodStart);
                return new ClassMethodSignature(className, methodName, methodDesc);
            }
        }
        return null;
    }

    public static MethodMatcher createExactMethodMatcher(String methodName, String methodDesc) {
        ExactMethodMatcher methodMatcher = new ExactMethodMatcher(methodName, methodDesc);
        return PointCutFactory.validateMethodMatcher(methodMatcher);
    }

    public static MethodMatcher createExactMethodMatcher(String methodName, Collection<String> methodDescriptions) {
        ExactMethodMatcher methodMatcher = new ExactMethodMatcher(methodName, methodDescriptions);
        return PointCutFactory.validateMethodMatcher(methodMatcher);
    }

    private static MethodMatcher validateMethodMatcher(ExactMethodMatcher methodMatcher) {
        try {
            methodMatcher.validate();
            return methodMatcher;
        }
        catch (InvalidMethodDescriptor e) {
            Agent.LOG.log(Level.SEVERE, e.toString());
            Agent.LOG.log(Level.FINER, "Error creating method matcher", e);
            return new NoMethodsMatcher();
        }
    }

    public static Collection<ConfigurationConstruct> getConstructs() {
        return new InstrumentationConstructor().constructs;
    }

    private static class SimpleMetricNameFormatFactory
    implements MetricNameFormatFactory {
        private final MetricNameFormat metricNameFormat;

        public SimpleMetricNameFormatFactory(MetricNameFormat metricNameFormat) {
            this.metricNameFormat = metricNameFormat;
        }

        public MetricNameFormat getMetricNameFormat(ClassMethodSignature sig, Object object, Object[] args) {
            return this.metricNameFormat;
        }
    }

    public static class ClassMethodNameFormatDescriptor
    implements MetricNameFormatFactory {
        private final String prefix;

        public ClassMethodNameFormatDescriptor(String prefix, boolean dispatcher) {
            this.prefix = ClassMethodNameFormatDescriptor.getMetricPrefix(prefix, dispatcher);
        }

        public MetricNameFormat getMetricNameFormat(ClassMethodSignature sig, Object object, Object[] args) {
            if (Strings.isEmpty(this.prefix)) {
                return new ClassMethodMetricNameFormat(sig, object);
            }
            return new ClassMethodMetricNameFormat(sig, object, this.prefix);
        }

        private static String getMetricPrefix(String prefix, boolean dispatcher) {
            if (dispatcher) {
                if (prefix.startsWith("OtherTransaction")) {
                    return prefix;
                }
                return "OtherTransaction/" + prefix;
            }
            return prefix;
        }
    }
}

