/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.jmx.JmxService;
import com.newrelic.agent.jmx.StatsFactory;
import com.newrelic.agent.jmx.UnknownStatsTypeException;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConfigFactory {
    private static final String SIMPLE_STATS_TYPE = "simple";
    private static final String MONOTONICALLY_INCREASING_STATS_TYPE = "monotonically_increasing";
    private final Map<String, StatsFactory> statsTypesToFactories = this.initializeStatsFactories();

    private Map<String, StatsFactory> initializeStatsFactories() {
        HashMap<String, StatsFactory> factories = new HashMap<String, StatsFactory>();
        factories.put(MONOTONICALLY_INCREASING_STATS_TYPE, new StatsFactory(){

            public Stats getStats(StatsEngine statsEngine, String metricName) {
                return statsEngine.getMonotonicallyIncreasingStats(metricName);
            }
        });
        factories.put(SIMPLE_STATS_TYPE, new StatsFactory(){

            public Stats getStats(StatsEngine statsEngine, String metricName) {
                return statsEngine.getStats(metricName);
            }
        });
        return factories;
    }

    public JmxConfig getJmxConfig(Map jmxConfig) throws MalformedObjectNameException {
        return new JmxConfig(jmxConfig);
    }

    protected JmxConfig getJmxConfig5(Map jmxConfig) throws MalformedObjectNameException {
        return new JmxConfig5(jmxConfig);
    }

    static JmxConfigFactory createJmxConfigFactory(InstrumentationProxy instrumentation) {
        return JmxConfigFactory.createJmxConfigFactory(instrumentation == null ? 6 : instrumentation.getMinorJVMVersion());
    }

    static JmxConfigFactory createJmxConfigFactory(int minorJVMVersion) {
        if (minorJVMVersion == 5) {
            return new JmxConfigFactory5();
        }
        return new JmxConfigFactory();
    }

    public Collection<JmxMetric> getJmxMetrics(Map metric) throws UnknownStatsTypeException {
        String type = (String)metric.get("type");
        type = type == null ? MONOTONICALLY_INCREASING_STATS_TYPE : type;
        StatsFactory statsFactory = this.statsTypesToFactories.get(type);
        if (statsFactory == null) {
            throw new UnknownStatsTypeException("Unknown JMX metric type " + type);
        }
        String attributes = (String)metric.get("attributes");
        if (attributes != null) {
            ArrayList<JmxMetric> metrics = new ArrayList<JmxMetric>();
            for (String attr : attributes.split(",")) {
                metrics.add(new JmxMetric(attr.trim(), statsFactory));
            }
            return metrics;
        }
        String attribute = (String)metric.get("attribute");
        if (attribute != null) {
            return Arrays.asList(new JmxMetric(attribute.trim(), statsFactory));
        }
        return Collections.EMPTY_LIST;
    }

    static final class JmxMetric {
        private final String attribute;
        private final StatsFactory statsFactory;

        public JmxMetric(String attribute, StatsFactory statsFactory) {
            this.attribute = attribute;
            this.statsFactory = statsFactory;
        }

        public Stats getStats(StatsEngine statsEngine, String metricName) {
            return this.statsFactory.getStats(statsEngine, metricName);
        }

        public String getAttribute() {
            return this.attribute;
        }
    }

    private class JmxConfig5
    extends JmxConfig {
        public JmxConfig5(Map jmxConfig) throws MalformedObjectNameException {
            super(jmxConfig);
        }

        protected String getSafeObjectName(String objectNameString) {
            Matcher matcher = JmxService.typeQueryPattern.matcher(objectNameString);
            if (matcher.find()) {
                String group = matcher.group(1);
                int start = matcher.start();
                objectNameString = objectNameString.substring(0, start) + ",*";
            }
            return objectNameString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JmxConfig {
        private final Map<String, JmxMetric> metrics;
        private ObjectName objectName;
        private final String objectNameString;

        public JmxConfig(Map jmxConfig) throws MalformedObjectNameException {
            this.objectNameString = (String)jmxConfig.get("object_name");
            Boolean enabled = (Boolean)jmxConfig.get("enabled");
            if (enabled == null || enabled.booleanValue()) {
                String safeName = this.getSafeObjectName(this.objectNameString);
                try {
                    this.objectName = new ObjectName(safeName);
                }
                catch (MalformedObjectNameException e) {
                    if (!this.objectNameString.equals(safeName)) {
                        safeName = safeName + '(' + this.objectNameString + ')';
                    }
                    Agent.LOG.log(Level.SEVERE, "Skipping bad Jmx object name : {0}.  {1}", new Object[]{safeName, e.toString()});
                    Agent.LOG.log(Level.FINER, "Jmx config error", e);
                    throw e;
                }
                this.metrics = this.initializeMetrics(jmxConfig);
            } else {
                this.metrics = Collections.emptyMap();
            }
        }

        private Map<String, JmxMetric> initializeMetrics(Map jmxConfig) {
            HashMap<String, JmxMetric> metricsMap = new HashMap<String, JmxMetric>();
            List metrics = (List)jmxConfig.get("metrics");
            for (Map metric : metrics) {
                try {
                    for (JmxMetric jmxMetric : JmxConfigFactory.this.getJmxMetrics(metric)) {
                        metricsMap.put(jmxMetric.getAttribute(), jmxMetric);
                    }
                }
                catch (UnknownStatsTypeException e) {
                    Agent.LOG.log(Level.SEVERE, e.getMessage());
                }
            }
            return metricsMap;
        }

        protected String getSafeObjectName(String objectNameString) {
            return objectNameString;
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }

        public String getObjectNameString() {
            return this.objectNameString;
        }

        public Map<String, JmxMetric> getMetrics() {
            return this.metrics;
        }
    }

    private static class JmxConfigFactory5
    extends JmxConfigFactory {
        private JmxConfigFactory5() {
        }

        public JmxConfig getJmxConfig(Map jmxConfig) throws MalformedObjectNameException {
            return this.getJmxConfig5(jmxConfig);
        }
    }
}

