/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.profile.ProfiledMethod;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSegment
implements JSONStreamAware {
    private final ProfiledMethod method;
    private int runnableCallCount = 0;
    private int nonrunnableCallCount = 0;
    private final Map<ProfiledMethod, ProfileSegment> children = new HashMap<ProfiledMethod, ProfileSegment>();

    private ProfileSegment(ProfiledMethod method) {
        this.method = method;
    }

    public static ProfileSegment newProfileSegment(ProfiledMethod method) {
        if (method == null) {
            return null;
        }
        return new ProfileSegment(method);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.method, this.runnableCallCount, this.nonrunnableCallCount, new ArrayList<ProfileSegment>(this.children.values())), out);
    }

    public String toString() {
        return this.method.toString();
    }

    public ProfiledMethod getMethod() {
        return this.method;
    }

    protected int getRunnableCallCount() {
        return this.runnableCallCount;
    }

    public void incrementRunnableCallCount() {
        ++this.runnableCallCount;
    }

    public void incrementNonRunnableCallCount() {
        ++this.nonrunnableCallCount;
    }

    Collection<ProfileSegment> getChildren() {
        return this.children.values();
    }

    ProfileSegment addChild(ProfiledMethod method) {
        ProfileSegment result = this.children.get(method);
        if (result == null) {
            result = ProfileSegment.newProfileSegment(method);
            this.children.put(method, result);
        }
        return result;
    }

    void removeChild(ProfiledMethod method) {
        this.children.remove(method);
    }

    public int getCallSiteCount() {
        int count = 1;
        for (ProfileSegment segment : this.children.values()) {
            count += segment.getCallSiteCount();
        }
        return count;
    }

    public int getCallCount(ProfiledMethod method) {
        int count = method.equals(this.getMethod()) ? this.runnableCallCount : 0;
        for (ProfileSegment kid : this.children.values()) {
            count += kid.getCallCount(method);
        }
        return count;
    }

    public Set<ProfiledMethod> getMethods() {
        HashSet<ProfiledMethod> methods = new HashSet<ProfiledMethod>();
        methods.add(this.getMethod());
        for (ProfileSegment kid : this.children.values()) {
            methods.addAll(kid.getMethods());
        }
        return methods;
    }
}

