/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.commands.DisabledCommand;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.profile.ProfileSession;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.StartProfilerCommand;
import com.newrelic.agent.profile.StopProfilerCommand;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.TimeConversion;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ProfilerService
extends AbstractService
implements ProfilerControl {
    private static final String PROFILER_THREAD_NAME = "New Relic Profiler Service";
    private final boolean enabled;
    private ProfileSession currentSession;
    private final long alwaysOnSamplePeriodMillis;
    private final long alwaysOnSnapshotPeriodMillis;
    private final ScheduledExecutorService scheduledExecutor;

    public ProfilerService() {
        super(ProfilerService.class.getSimpleName());
        AgentConfig agentConfig = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        Config config = agentConfig.getProfilerConfig();
        this.enabled = config.getProperty("enabled", true);
        if (this.enabled) {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(PROFILER_THREAD_NAME, true);
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        } else {
            this.scheduledExecutor = null;
        }
        Object samplePeriod = config.getProperty("sample_period");
        Object snapshotPeriod = config.getProperty("snapshot_period");
        if (samplePeriod != null && snapshotPeriod != null) {
            this.alwaysOnSamplePeriodMillis = TimeConversion.convertSecondsToMillis(((Number)samplePeriod).doubleValue());
            this.alwaysOnSnapshotPeriodMillis = TimeConversion.convertSecondsToMillis(((Number)snapshotPeriod).doubleValue());
        } else {
            this.alwaysOnSamplePeriodMillis = 0L;
            this.alwaysOnSnapshotPeriodMillis = 0L;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean alwaysOn() {
        return this.alwaysOnSamplePeriodMillis > 0L && this.alwaysOnSnapshotPeriodMillis > 0L;
    }

    public synchronized void startProfiler(ProfilerParameters parameters, long samplePeriodInMillis, long durationInMillis) {
        if (!this.enabled || samplePeriodInMillis <= 0L || durationInMillis <= 0L || samplePeriodInMillis > durationInMillis) {
            this.getLogger().log(Level.FINER, "Ignoring the start profiler command: enabled={0}, samplePeriodInMillis={1}, durationInMillis={2}", new Object[]{this.enabled, samplePeriodInMillis, durationInMillis});
            return;
        }
        ProfileSession oldSession = this.currentSession;
        if (oldSession != null && !oldSession.isDone()) {
            if (!oldSession.isAlwaysOn()) {
                this.getLogger().log(Level.FINER, "Ignoring the start profiler command because a session is currently active. {0}", oldSession.getProfileId());
                return;
            }
            oldSession.stop(true);
        }
        ProfileSession newSession = this.createProfileSession(parameters, false);
        newSession.start(samplePeriodInMillis, durationInMillis);
        this.currentSession = newSession;
    }

    private synchronized void startAlwaysOnProfiler() {
        if (this.currentSession != null) {
            return;
        }
        ProfilerParameters parameters = new ProfilerParameters(null, false, false, Agent.isDebugEnabled());
        ProfileSession newSession = this.createProfileSession(parameters, true);
        newSession.start(this.alwaysOnSamplePeriodMillis, this.alwaysOnSnapshotPeriodMillis);
        this.currentSession = newSession;
    }

    public synchronized int stopProfiler(Long profileId, boolean shouldReport) {
        ProfileSession session = this.currentSession;
        if (session != null && profileId.equals(session.getProfileId())) {
            session.stop(shouldReport);
            return 0;
        }
        return -1;
    }

    synchronized void sessionCompleted(ProfileSession session) {
        if (this.currentSession != session) {
            return;
        }
        this.currentSession = null;
        if (this.alwaysOn()) {
            this.startAlwaysOnProfiler();
        }
    }

    protected ProfileSession createProfileSession(ProfilerParameters parameters, boolean alwaysOn) {
        return new ProfileSession(this, parameters, alwaysOn);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutor;
    }

    protected void doStart() {
        if (this.isEnabled() && this.alwaysOn()) {
            this.startAlwaysOnProfiler();
        }
        this.addCommands();
    }

    protected synchronized ProfileSession getCurrentSession() {
        return this.currentSession;
    }

    private void addCommands() {
        if (this.isEnabled()) {
            ServiceManagerFactory.getServiceManager().getCommandParser().addCommands(new StartProfilerCommand(this));
            ServiceManagerFactory.getServiceManager().getCommandParser().addCommands(new StopProfilerCommand(this));
        } else {
            ServiceManagerFactory.getServiceManager().getCommandParser().addCommands(new DisabledCommand("start_profiler", "The profiler service is disabled"));
            ServiceManagerFactory.getServiceManager().getCommandParser().addCommands(new DisabledCommand("stop_profiler", "The profiler service is disabled"));
        }
    }

    protected void doStop() {
        ProfileSession session = this.getCurrentSession();
        if (session != null) {
            session.stop(false);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                if (!this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.getLogger().log(Level.FINE, "ScheduledExecutorService did not terminate");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

