/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.util.TimeConversion;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class StartProfilerCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "start_profiler";
    private final ProfilerControl profilerControl;

    public StartProfilerCommand(ProfilerControl profilerControl) {
        super(COMMAND_NAME);
        this.profilerControl = profilerControl;
    }

    public Map process(IRPMService rpmService, Map arguments) throws CommandException {
        long durationLong;
        long samplePeriodLong;
        if (arguments.size() < 3) {
            throw new CommandException("The start_profiler command expected 3 arguments");
        }
        Object duration = arguments.remove("duration");
        Object period = arguments.remove("sample_period");
        Object profileId = arguments.remove("profile_id");
        Object onlyRunnables = arguments.remove("only_runnable_threads");
        Object breakoutByUrl = arguments.remove("breakout_by_url");
        Object profileAgentCodeValue = arguments.remove("profile_agent_code");
        if (!(duration instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid duration: " + duration);
        }
        if (!(period instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid period: " + period);
        }
        if (!(profileId instanceof Number)) {
            throw new CommandException("The start_profiler command encountered an invalid profile id: " + profileId);
        }
        boolean profileAgentThreads = Agent.isDebugEnabled();
        if (profileAgentCodeValue != null) {
            boolean bl = profileAgentThreads = profileAgentCodeValue instanceof Boolean && (Boolean)profileAgentCodeValue != false;
        }
        if ((samplePeriodLong = TimeConversion.convertSecondsToMillis(((Number)period).doubleValue())) > (durationLong = TimeConversion.convertSecondsToMillis(((Number)duration).doubleValue()))) {
            throw new CommandException(MessageFormat.format("The start_profiler command requires the sample period to be less than the duration.  Sample period : {0}, duration : {1}", period, duration));
        }
        if (arguments.size() > 0) {
            Agent.LOG.log(Level.WARNING, "The start profiler command didn''t recognize the following arguments: {0}", arguments.keySet().toString());
        }
        ProfilerParameters parameters = new ProfilerParameters(((Number)profileId).longValue(), onlyRunnables != null && (Boolean)onlyRunnables != false, breakoutByUrl != null && (Boolean)breakoutByUrl != false, profileAgentThreads);
        this.profilerControl.startProfiler(parameters, samplePeriodLong, durationLong);
        return Collections.EMPTY_MAP;
    }
}

