/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.TimeConversion;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;

public abstract class AbstractCPUSampler {
    private double lastCPUTimeSeconds;
    private long lastTimestampMillis;
    private final int processorCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();

    protected AbstractCPUSampler() {
        Agent.LOG.finer(this.processorCount + " processor(s)");
    }

    protected abstract double getProcessCpuTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordCPU(IRPMService service) {
        double currentProcessTime = this.getProcessCpuTime();
        double dCPU = currentProcessTime - this.lastCPUTimeSeconds;
        long now = System.currentTimeMillis();
        long elapsedMillis = now - this.lastTimestampMillis;
        this.lastTimestampMillis = now;
        this.lastCPUTimeSeconds = currentProcessTime;
        double utilization = dCPU / (TimeConversion.convertMillisToSeconds(elapsedMillis) * (double)this.processorCount);
        Agent.LOG.log(Level.FINER, "Recorded CPU time: {0} ({1})  {2}", new Object[]{dCPU, utilization, this.getClass().getName()});
        if (this.lastCPUTimeSeconds > 0.0 && dCPU >= 0.0) {
            StatsEngine statsEngine = service.getStatsEngine();
            Object object = statsEngine.getHarvestLock();
            synchronized (object) {
                if (Double.isNaN(dCPU) || Double.isInfinite(dCPU)) {
                    Agent.LOG.log(Level.FINER, "Infinite or non-number CPU time: {0} (current) - {1} (last)", new Object[]{currentProcessTime, this.lastCPUTimeSeconds});
                } else {
                    statsEngine.getStats("CPU/User Time").recordDataPoint((float)dCPU);
                }
                if (Double.isNaN(utilization) || Double.isInfinite(utilization)) {
                    Agent.LOG.log(Level.FINER, "Infinite or non-number CPU utilization: {0} ({1})", new Object[]{utilization, dCPU});
                } else {
                    statsEngine.getStats("CPU/User/Utilization").recordDataPoint((float)utilization);
                }
            }
        } else {
            Agent.LOG.log(Level.FINER, "Bad CPU time: {0} (current) - {1} (last)", new Object[]{currentProcessTime, this.lastCPUTimeSeconds});
        }
    }
}

