/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.samplers.MemorySampler;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.ThreadSampler;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SamplerServiceImpl
extends AbstractService
implements SamplerService {
    private static final String SAMPLER_THREAD_NAME = "New Relic Sampler Service";
    private static final long INITIAL_DELAY_IN_MILLISECONDS = 1000L;
    private static final long DELAY_IN_MILLISECONDS = 5000L;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<ScheduledFuture<?>> tasks = new CopyOnWriteArrayList();

    public SamplerServiceImpl() {
        super(SamplerService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(SAMPLER_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    protected void doStart() {
        MemorySampler memorySampler = new MemorySampler();
        memorySampler.start();
        this.addMetricSampler(memorySampler, 1000L, 5000L, TimeUnit.MILLISECONDS);
        ThreadSampler threadSampler = new ThreadSampler();
        this.addMetricSampler(threadSampler, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        for (ScheduledFuture<?> task : this.tasks) {
            task.cancel(false);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public void addMetricSampler(final MetricSampler sampler, long initialDelay, long delay, TimeUnit unit) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (ServiceManagerFactory.getServiceManager().getAgent().isEnabled()) {
                        sampler.sample();
                    }
                }
                catch (Throwable t) {
                    SamplerServiceImpl.this.getLogger().severe("Unable to sample " + this.getClass().getName());
                    SamplerServiceImpl.this.getLogger().log(Level.FINER, "sampler error", t);
                }
            }
        };
        ScheduledFuture<?> task = this.scheduledExecutor.scheduleWithFixedDelay(runnable, initialDelay, delay, unit);
        this.tasks.add(task);
    }
}

