/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceState;
import java.util.logging.Logger;

public abstract class AbstractService
implements Service {
    private final Logger logger;
    private final String name;
    private final State state = new State();

    protected AbstractService(String name) {
        this.name = name;
        this.logger = Agent.LOG.getChildLogger(this.getClass());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public final String getName() {
        return this.name;
    }

    public boolean isStartedOrStarting() {
        return this.state.isStartedOrStarting();
    }

    public boolean isStoppedOrStopping() {
        return this.state.isStoppedOrStopping();
    }

    public boolean isStarted() {
        return this.state.isStarted();
    }

    public boolean isStopped() {
        return this.state.isStopped();
    }

    public final void start() throws Exception {
        if (this.state.beginStart()) {
            this.doStart();
            this.state.endStart();
        }
    }

    protected abstract void doStart() throws Exception;

    public final void stop() throws Exception {
        if (this.state.beginStop()) {
            this.doStop();
            this.state.endStop();
        }
    }

    protected abstract void doStop() throws Exception;

    private static final class State {
        private ServiceState serviceState = ServiceState.STOPPED;

        private State() {
        }

        private synchronized boolean beginStart() {
            if (this.serviceState == ServiceState.STOPPED) {
                this.serviceState = ServiceState.STARTING;
                return true;
            }
            return false;
        }

        private synchronized void endStart() {
            this.serviceState = ServiceState.STARTED;
        }

        private synchronized boolean beginStop() {
            if (this.serviceState == ServiceState.STARTED) {
                this.serviceState = ServiceState.STOPPING;
                return true;
            }
            return false;
        }

        private synchronized void endStop() {
            this.serviceState = ServiceState.STOPPED;
        }

        private synchronized boolean isStarted() {
            return this.serviceState == ServiceState.STARTED;
        }

        private synchronized boolean isStartedOrStarting() {
            return this.serviceState == ServiceState.STARTED || this.serviceState == ServiceState.STARTING;
        }

        private synchronized boolean isStoppedOrStopping() {
            return this.serviceState == ServiceState.STOPPED || this.serviceState == ServiceState.STOPPING;
        }

        private synchronized boolean isStopped() {
            return this.serviceState == ServiceState.STOPPED;
        }
    }
}

