/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.org.json.simple.JSONArray;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public class ApdexStatsImpl
implements ApdexStats {
    private static final Integer ZERO = 0;
    private int satisfying;
    private int tolerating;
    private int frustrating;
    private final long apdexIInMillis;
    private final Object lock;

    ApdexStatsImpl(Object lock, long apdexTInMillis) {
        this.apdexIInMillis = apdexTInMillis;
        this.lock = lock;
    }

    public ApdexStatsImpl(int s, int t, int f) {
        this.satisfying = s;
        this.tolerating = t;
        this.frustrating = f;
        this.lock = this;
        this.apdexIInMillis = 0L;
    }

    protected Object clone() throws CloneNotSupportedException {
        ApdexStatsImpl newStats = new ApdexStatsImpl(this.lock, this.apdexIInMillis);
        newStats.frustrating = this.frustrating;
        newStats.satisfying = this.satisfying;
        newStats.tolerating = this.tolerating;
        return newStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordApdexResponseTime(long responseTimeMillis, long tMillis) {
        Object object = this.lock;
        synchronized (object) {
            if (responseTimeMillis <= tMillis) {
                ++this.satisfying;
            } else if (responseTimeMillis <= 4L * tMillis) {
                ++this.tolerating;
            } else {
                this.recordApdexFrustrated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordApdexFrustrated() {
        Object object = this.lock;
        synchronized (object) {
            ++this.frustrating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApdexSatisfying() {
        Object object = this.lock;
        synchronized (object) {
            return this.satisfying;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApdexTolerating() {
        Object object = this.lock;
        synchronized (object) {
            return this.tolerating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApdexFrustrating() {
        Object object = this.lock;
        synchronized (object) {
            return this.frustrating;
        }
    }

    public void recordApdexResponseTime(long responseTimeMillis) {
        this.recordApdexResponseTime(responseTimeMillis, this.apdexIInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.lock;
        synchronized (object) {
            return this.satisfying > 0 || this.tolerating > 0 || this.frustrating > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.satisfying = 0;
            this.tolerating = 0;
            this.frustrating = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJSONString(Writer writer) throws IOException {
        List<Integer> data;
        Object object = this.lock;
        synchronized (object) {
            data = Arrays.asList(this.satisfying, this.tolerating, this.frustrating, ZERO, ZERO, ZERO);
        }
        JSONArray.writeJSONString(data, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(StatsBase statsObj) {
        if (statsObj instanceof ApdexStatsImpl) {
            ApdexStatsImpl stats = (ApdexStatsImpl)statsObj;
            Object object = this.lock;
            synchronized (object) {
                this.satisfying += stats.satisfying;
                this.tolerating += stats.tolerating;
                this.frustrating += stats.frustrating;
            }
        }
    }

    public boolean isValid() {
        return true;
    }
}

