/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import com.newrelic.agent.instrumentation.pointcuts.database.DatabaseUtils;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.org.apache.axis.encoding.Base64;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTrace
implements Comparable<TransactionTrace>,
JSONStreamAware {
    private final TransactionSegment rootSegment;
    private final List<TransactionSegment> sqlSegments;
    private final Map<ConnectionFactory, List<ExplainPlanExecutor>> sqlTracers;
    private final long duration;
    private final long startTime;
    private String requestUri;
    private final String rootMetricName;
    private final Map<String, Object> parameters;
    private final SqlObfuscator sqlObfuscator;
    private final long rootTracerStartTime;

    private TransactionTrace(TransactionData transactionData, SqlObfuscator sqlObfuscator) {
        Long cpuTime;
        Long gcTime;
        this.sqlObfuscator = sqlObfuscator;
        this.sqlTracers = new HashMap<ConnectionFactory, List<ExplainPlanExecutor>>();
        Tracer tracer = transactionData.getRootTracer();
        this.parameters = transactionData.getParameters();
        this.startTime = transactionData.getStartTime();
        this.rootTracerStartTime = tracer.getStartTimeInMilliseconds();
        this.sqlSegments = new LinkedList<TransactionSegment>();
        this.requestUri = transactionData.getRequestUri();
        if (this.requestUri == null || this.requestUri.length() == 0) {
            this.requestUri = "/ROOT";
        }
        this.rootMetricName = transactionData.getBlameOrRootMetricName();
        this.rootSegment = new TransactionSegment(sqlObfuscator, this.rootTracerStartTime, tracer, this.createTransactionSegment(tracer, null));
        this.rootSegment.setMetricName("ROOT");
        this.duration = tracer.getDurationInMilliseconds();
        if (Agent.isDebugEnabled()) {
            this.parameters.put("segment_count", transactionData.getTracers().size());
        }
        if ((gcTime = (Long)this.parameters.remove("gc_time")) != null) {
            this.parameters.put("gc_time", gcTime);
        }
        if ((cpuTime = (Long)this.parameters.remove("cpu_time")) != null) {
            this.parameters.put("cpu_time", TimeUnit.MILLISECONDS.convert(cpuTime, TimeUnit.NANOSECONDS));
        }
    }

    private static SqlObfuscator getSqlObfuscator() {
        SqlObfuscator sqlObfuscator = SqlObfuscator.getInstance();
        return SqlObfuscator.getCachingSqlObfuscator(sqlObfuscator);
    }

    public static TransactionTrace getTransactionTrace(TransactionData transactionData) {
        return TransactionTrace.getTransactionTrace(transactionData, TransactionTrace.getSqlObfuscator());
    }

    public static TransactionTrace getTransactionTrace(TransactionData transactionData, SqlObfuscator sqlObfuscator) {
        return new TransactionTrace(transactionData, sqlObfuscator);
    }

    public TransactionSegment getRootSegment() {
        return this.rootSegment;
    }

    private TransactionSegment createTransactionSegment(Tracer tracer, TransactionSegment lastSibling) {
        TransactionSegment segment = tracer.getTransactionSegment(this.sqlObfuscator, this.rootTracerStartTime, lastSibling);
        this.processSqlTracer(tracer);
        Collection<Tracer> children = tracer.getChildren();
        if (children != null) {
            TransactionSegment lastKid = null;
            for (Tracer child : children) {
                TransactionSegment childSegment;
                if (child.getTransactionSegmentName() == null || (childSegment = this.createTransactionSegment(child, lastKid)) == lastKid) continue;
                this.addChildSegment(segment, childSegment);
                lastKid = childSegment;
            }
        }
        return segment;
    }

    public Map<ConnectionFactory, List<ExplainPlanExecutor>> getExplainPlanExecutors() {
        return Collections.unmodifiableMap(this.sqlTracers);
    }

    private void processSqlTracer(Tracer tracer) {
        if (tracer instanceof SqlStatementTracer) {
            SqlStatementTracer sqlTracer = (SqlStatementTracer)tracer;
            ExplainPlanExecutor explainExecutor = sqlTracer.getExplainPlanExecutor();
            ConnectionFactory connectionFactory = sqlTracer.getConnectionFactory();
            if (explainExecutor != null && connectionFactory != null) {
                List<ExplainPlanExecutor> tracers = this.sqlTracers.get(connectionFactory);
                if (tracers == null) {
                    tracers = new LinkedList<ExplainPlanExecutor>();
                    this.sqlTracers.put(connectionFactory, tracers);
                }
                tracers.add(explainExecutor);
            }
        }
    }

    private void addChildSegment(TransactionSegment parent, TransactionSegment child) {
        if (child.getMetricName() == null) {
            for (TransactionSegment kid : child.getChildren()) {
                this.addChildSegment(parent, kid);
            }
        } else {
            parent.addChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExplainPlans() {
        if (!this.sqlTracers.isEmpty()) {
            for (Map.Entry<ConnectionFactory, List<ExplainPlanExecutor>> entry : this.sqlTracers.entrySet()) {
                Agent.LOG.log(Level.FINER, "Running {0} explain plan(s)", entry.getValue().size());
                Connection connection = null;
                try {
                    connection = entry.getKey().getConnection();
                    ExplainPlanExecutor.DatabaseVendor vendor = DatabaseUtils.getDatabaseVendor(connection);
                    for (ExplainPlanExecutor explainExecutor : entry.getValue()) {
                        if (explainExecutor == null) continue;
                        explainExecutor.runExplainPlan(connection, vendor);
                    }
                }
                catch (Throwable t) {
                    String msg = MessageFormat.format("An error occurred executing an explain plan: {0}", t.toString());
                    if (Agent.LOG.isLoggable(Level.FINER)) {
                        Agent.LOG.log(Level.FINER, msg, t);
                        continue;
                    }
                    Agent.LOG.fine(msg);
                }
                finally {
                    if (connection == null) continue;
                    try {
                        connection.close();
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINER, "Unable to close connection", e);
                    }
                }
            }
            this.sqlTracers.clear();
        }
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        this.runExplainPlans();
        Map requestParameters = this.getRequestParameters();
        List<Object> data = Arrays.asList(this.startTime, requestParameters, this.parameters, this.rootSegment);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        DeflaterOutputStream zipStream = new DeflaterOutputStream((OutputStream)outStream, new Deflater(1));
        OutputStreamWriter out = new OutputStreamWriter(zipStream);
        try {
            JSONArray.writeJSONString(data, out);
            ((Writer)out).flush();
            ((Writer)out).close();
            outStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONArray.writeJSONString(Arrays.asList(this.startTime, this.duration, this.rootMetricName, this.requestUri, Base64.encode(outStream.toByteArray())), writer);
    }

    private Map getRequestParameters() {
        Map params = (Map)this.parameters.remove("request_parameters");
        if (params == null) {
            return Collections.EMPTY_MAP;
        }
        return params;
    }

    protected List<TransactionSegment> getSQLSegments() {
        return this.sqlSegments;
    }

    public String toString() {
        return MessageFormat.format("{0} {1} ms", this.requestUri, this.duration);
    }

    @Override
    public int compareTo(TransactionTrace o) {
        return (int)(this.duration - o.duration);
    }

    public long getDuration() {
        return this.duration;
    }

    public String getRequestUri() {
        return this.requestUri;
    }
}

