/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.trace.TransactionTrace;
import java.util.logging.Logger;

public class TransactionTraceBucket {
    private final boolean enabled;
    private final Logger logger;
    private TransactionTrace expensiveTransaction;

    public TransactionTraceBucket(Logger logger, boolean enabled) {
        this.logger = logger;
        this.enabled = enabled;
    }

    public synchronized void noticeTransaction(TransactionData transactionData) {
        if (!this.enabled) {
            return;
        }
        boolean debugEnabled = Agent.isDebugEnabled();
        if (transactionData.getDuration() > transactionData.getTransactionThreshold()) {
            if (this.expensiveTransaction == null || this.expensiveTransaction.getDuration() < transactionData.getDuration()) {
                TransactionTrace transactionTrace;
                this.expensiveTransaction = transactionTrace = TransactionTrace.getTransactionTrace(transactionData);
                if (debugEnabled) {
                    this.logger.finer("Captured expensive transaction trace " + this.expensiveTransaction);
                }
            } else if (debugEnabled) {
                this.logger.finer("Transaction trace " + this.expensiveTransaction + " is slower than " + transactionData);
            }
        } else if (debugEnabled) {
            this.logger.finer("Transaction trace threshold not exceeded " + transactionData);
        }
    }

    public synchronized TransactionTrace getAndResetExpensiveTransaction() {
        TransactionTrace result = this.expensiveTransaction;
        this.expensiveTransaction = null;
        return result;
    }
}

