/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Trace;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;

public class CustomTracerFactory
implements TracerFactory {
    private final TracerFactory tracerFactory;

    public CustomTracerFactory(ClassMethodSignature classMethodSignature, Trace trace) {
        this.tracerFactory = this.initializeTracerFactory(classMethodSignature, trace);
    }

    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        TracerFactory factory = this.tracerFactory;
        return factory.getTracer(transaction, sig, object, args);
    }

    private TracerFactory initializeTracerFactory(ClassMethodSignature sig, Trace traceAnnotation) {
        String metricName = traceAnnotation.metricName();
        String customName = metricName != null && 0 != metricName.length() ? metricName : null;
        return traceAnnotation.dispatcher() ? this.makeCusutomDispatcherTracerFactory(customName) : this.makeCustomMetricTracerFactory(customName);
    }

    private TracerFactory makeCusutomDispatcherTracerFactory(final String metricName) {
        return new TracerFactory(){

            public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
                SimpleMetricNameFormat metricFormatter = new SimpleMetricNameFormat(metricName != null ? "OtherTransaction/Custom/" + metricName : ClassMethodMetricNameFormat.getMetricName(sig, "OtherTransaction/Custom"));
                return new OtherDispatcherTracer(transaction, sig, object, metricFormatter);
            }
        };
    }

    private TracerFactory makeCustomMetricTracerFactory(final String metricName) {
        return new TracerFactory(){

            public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
                SimpleMetricNameFormat metricFormatter = new SimpleMetricNameFormat(metricName != null ? metricName : ClassMethodMetricNameFormat.getMetricName(sig, "Custom"));
                return new DefaultTracer(transaction, sig, object, metricFormatter);
            }
        };
    }
}

