/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.AbstractTracer;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTracer
extends AbstractTracer {
    private static final MetricNameFormat NULL_METRIC_NAME_FORMATTER = new SimpleMetricNameFormat(null);
    private final long startTime;
    private long duration;
    private long exclusiveDuration;
    private boolean measured;
    private Map<String, Object> parameters;
    private final Transaction transaction;
    private final Tracer parentTracer;
    private List<Tracer> children;
    private Throwable throwable;
    private boolean recordMetric;
    private ClassMethodSignature classMethodSignature;
    private boolean transactionSegment;
    private Object invocationTarget;
    private MetricNameFormat metricNameFormat;
    protected final boolean generateTransactionSegment;
    private static final int INITIAL_PARAMETER_MAP_SIZE = 5;

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat metricNameFormatter) {
        this.metricNameFormat = metricNameFormatter;
        this.classMethodSignature = sig;
        this.recordMetric = true;
        this.startTime = System.nanoTime();
        this.transaction = transaction;
        this.invocationTarget = object;
        this.parentTracer = transaction.getLastTracer();
        this.transactionSegment = this.recordMetric;
        this.generateTransactionSegment = this.getTransaction().shouldGenerateTransactionSegment();
    }

    public DefaultTracer(Transaction transaction, ClassMethodSignature sig, Object object) {
        this(transaction, sig, object, NULL_METRIC_NAME_FORMATTER);
    }

    public final void setRecordMetric(boolean recordMetric) {
        this.recordMetric = recordMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finish(Throwable throwable) {
        try {
            this.doFinish(throwable);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.SEVERE, "An error occurred finishing tracer for class {0} : {1}", new Object[]{this.classMethodSignature.getClassName(), t.toString()});
            Agent.LOG.log(Level.FINER, t.toString(), t);
        }
        finally {
            if (!this.measured) {
                this.finish(191, null);
            }
            this.reset();
            if (Agent.isDebugEnabled()) {
                Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
            }
        }
    }

    protected void reset() {
        this.classMethodSignature = null;
        this.invocationTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void finish(int opcode, Object returnValue) {
        block18: {
            if (!this.measured) {
                block17: {
                    this.duration = Math.max(0L, System.nanoTime() - this.startTime);
                    this.exclusiveDuration += this.duration;
                    if (this.exclusiveDuration < 0L || this.exclusiveDuration > this.duration) {
                        Agent.LOG.log(Level.SEVERE, "Invalid exclusive time {0} for tracer {1}", new Object[]{this.exclusiveDuration, this.getClass().getName()});
                        this.exclusiveDuration = this.duration;
                    }
                    if (this.parentTracer != null) {
                        this.parentTracer.childTracerFinished(this);
                    }
                    if (191 == opcode) break block17;
                    this.doFinish(opcode, returnValue);
                }
                Object var5_3 = null;
                try {
                    if (!this.measured) {
                        this.measured = true;
                        if (!(this instanceof SkipTracer)) {
                            this.transaction.tracerFinished(this, opcode);
                        }
                    }
                    this.reset();
                }
                catch (Throwable t2) {
                    Agent.LOG.log(Level.SEVERE, "An error occurred calling Transaction.tracerFinished() for class {0} : {1}", new Object[]{this.classMethodSignature.getClassName(), t2.toString()});
                    Agent.LOG.log(Level.FINER, t2.toString(), t2);
                }
                break block18;
                {
                    catch (Throwable t) {
                        Agent.LOG.log(Level.SEVERE, "An error occurred finishing tracer for class {0} : {1}", new Object[]{this.classMethodSignature.getClassName(), t.toString()});
                        Agent.LOG.log(Level.FINER, t.toString(), t);
                        Object var5_4 = null;
                        try {
                            if (!this.measured) {
                                this.measured = true;
                                if (!(this instanceof SkipTracer)) {
                                    this.transaction.tracerFinished(this, opcode);
                                }
                            }
                            this.reset();
                        }
                        catch (Throwable t2) {
                            Agent.LOG.log(Level.SEVERE, "An error occurred calling Transaction.tracerFinished() for class {0} : {1}", new Object[]{this.classMethodSignature.getClassName(), t2.toString()});
                            Agent.LOG.log(Level.FINER, t2.toString(), t2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        if (!this.measured) {
                            this.measured = true;
                            if (!(this instanceof SkipTracer)) {
                                this.transaction.tracerFinished(this, opcode);
                            }
                        }
                        this.reset();
                    }
                    catch (Throwable t2) {
                        Agent.LOG.log(Level.SEVERE, "An error occurred calling Transaction.tracerFinished() for class {0} : {1}", new Object[]{this.classMethodSignature.getClassName(), t2.toString()});
                        Agent.LOG.log(Level.FINER, t2.toString(), t2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected void doFinish(Throwable throwable) {
        this.throwable = throwable;
        this.finish(191, null);
        if (Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINE, "(Debug) Tracer.finish(Throwable)");
        }
    }

    protected void doFinish(int opcode, Object returnValue) {
    }

    protected void put(String key, Object value) {
        if (this.parameters == null) {
            if (this.getTransaction().isOverTracerSegmentLimit()) {
                return;
            }
            this.parameters = new HashMap<String, Object>(1, 5.0f);
        }
        if (value.getClass().isArray()) {
            value = Arrays.asList((Object[])value);
        }
        this.transaction.incrementSize(DefaultTracer.sizeof(value));
        this.parameters.put(key, value);
    }

    static int sizeof(Object value) {
        int size = 0;
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof StackTraceElement) {
            StackTraceElement elem = (StackTraceElement)value;
            return DefaultTracer.sizeof(elem.getClassName()) + DefaultTracer.sizeof(elem.getFileName()) + DefaultTracer.sizeof(elem.getMethodName()) + 10;
        }
        if (value instanceof Object[]) {
            for (Object obj : (Object[])value) {
                size += DefaultTracer.sizeof(obj);
            }
        }
        return size;
    }

    @Override
    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return this.parameters;
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getExclusiveDuration() {
        return this.exclusiveDuration;
    }

    @Override
    public long getEndTime() {
        return this.startTime + this.duration;
    }

    @Override
    public long getEndTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getEndTime(), TimeUnit.NANOSECONDS);
    }

    public boolean isMeasured() {
        return this.measured;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.getStartTime(), TimeUnit.NANOSECONDS);
    }

    public final Transaction getTransaction() {
        return this.transaction;
    }

    protected final Object getInvocationTarget() {
        return this.invocationTarget;
    }

    public Tracer getParentTracer() {
        return this.parentTracer;
    }

    public String getRequestMetricName() {
        return null;
    }

    protected final void setMetricNameFormat(MetricNameFormat nameFormat) {
        this.metricNameFormat = nameFormat;
    }

    @Override
    public final String getMetricName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getMetricName();
    }

    @Override
    public final String getTransactionSegmentName() {
        return this.metricNameFormat == null ? null : this.metricNameFormat.getTransactionSegmentName();
    }

    protected MetricSpec getMetricSpecWithScope(String metricName, TransactionData transactionData) {
        if (this.parentTracer == null) {
            return MetricSpec.lookup(metricName);
        }
        return MetricSpec.lookup(metricName, transactionData.getBlameMetricName());
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public final void recordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
        if (this.recordMetric) {
            if (this.getMetricName() != null) {
                MetricSpec spec = this.getMetricSpecWithScope(this.getMetricName(), transactionData);
                statsEngine.getResponseTimeStats(spec).recordResponseTime(this.getDuration(), this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
            }
            this.doRecordMetrics(statsEngine, transactionData);
        }
    }

    protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
    }

    public List<Tracer> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    @Override
    public void childTracerFinished(Tracer child) {
        if (child.isMetricProducer() && !(child instanceof SkipTracer)) {
            this.exclusiveDuration -= child.getDuration();
            if (this.generateTransactionSegment && child.isTransactionSegment()) {
                if (this.children == null) {
                    this.children = new ArrayList<Tracer>(16);
                }
                this.children.add(child);
            }
        }
    }

    @Override
    public ClassMethodSignature getClassMethodSignature() {
        return this.classMethodSignature;
    }

    @Override
    public boolean isTransactionSegment() {
        return this.transactionSegment;
    }

    protected void setTransactionSegment(boolean isTransactionSegment) {
        this.transactionSegment = isTransactionSegment;
    }

    @Override
    public boolean isMetricProducer() {
        return this.recordMetric;
    }

    @Override
    public TransactionSegment getTransactionSegment(SqlObfuscator sqlObfuscator, long startTime, TransactionSegment lastSibling) {
        return new TransactionSegment(sqlObfuscator, startTime, this);
    }
}

