/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.IgnoreChildSocketCalls;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.util.Strings;
import java.util.concurrent.TimeUnit;

public class ExternalComponentTracer
extends DefaultTracer
implements IgnoreChildSocketCalls {
    private final String host;

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, String ... operations) {
        this(transaction, sig, object, host, library, false, operations);
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library, boolean includeOperationInMetric, String ... operations) {
        super(transaction, sig, object, new ExternalComponentNameFormat(host, library, includeOperationInMetric, operations));
        this.host = host;
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, String host, String library) {
        super(transaction, sig, object, ExternalComponentTracer.getMetricNameFormat(host, library));
        this.host = host;
    }

    public ExternalComponentTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormatWithHost metricNameFormat) {
        super(transaction, sig, object, metricNameFormat);
        this.host = metricNameFormat.getHost();
    }

    public static MetricNameFormatWithHost getMetricNameFormat(String host, String library) {
        return new MetricNameFormatWithHost(host, library);
    }

    protected void doRecordMetrics(StatsEngine statsEngine, TransactionData transactionData) {
        statsEngine.getResponseTimeStats("External/all").recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        statsEngine.getResponseTimeStats(transactionData.isWebTransaction() ? MetricSpec.WEB_TRANSACTION_EXTERNAL_ALL : MetricSpec.OTHER_TRANSACTION_EXTERNAL_ALL).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
        statsEngine.getResponseTimeStats(Strings.join('/', "External", this.host, "all")).recordResponseTime(this.getExclusiveDuration(), TimeUnit.NANOSECONDS);
    }

    static class ExternalComponentNameFormat
    implements MetricNameFormat {
        private String metricName;
        private String transactionSegmentName;
        private String[] operations;

        public ExternalComponentNameFormat(String host, String library, boolean includeOperationInMetric, String[] operations) {
            this.metricName = Strings.join('/', "External", host, library);
            if (includeOperationInMetric) {
                this.transactionSegmentName = this.metricName = this.metricName + this.fixOperations(operations);
            } else {
                this.operations = operations;
            }
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getTransactionSegmentName() {
            if (this.transactionSegmentName == null) {
                this.transactionSegmentName = this.metricName + this.fixOperations(this.operations);
            }
            return this.transactionSegmentName;
        }

        private String fixOperations(String[] operations) {
            StringBuilder builder = new StringBuilder();
            for (String operation : operations) {
                if (operation.startsWith("/")) {
                    builder.append(operation);
                    continue;
                }
                builder.append('/').append(operation);
            }
            return builder.toString();
        }
    }

    public static class MetricNameFormatWithHost
    extends SimpleMetricNameFormat {
        private final String host;

        public MetricNameFormatWithHost(String host, String library) {
            super(Strings.join('/', "External", host, library));
            this.host = host;
        }

        protected final String getHost() {
            return this.host;
        }
    }
}

