/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.IdentityTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFactory;
import com.newrelic.agent.tracers.servlet.GenericRequestDispatcherTracer;
import com.newrelic.agent.tracers.servlet.ServletTracer;
import com.newrelic.agent.util.ServletUtils;
import com.newrelic.agent.util.TransactionUtils;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ServletTracerFactory
implements TracerFactory {
    public Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object servlet, Object[] args) {
        Tracer lastTracer = transaction.getLastTracer();
        if (lastTracer == null) {
            return new GenericRequestDispatcherTracer(null, transaction, sig, servlet, args[0], args[1]);
        }
        int identityHashCode = System.identityHashCode(servlet);
        if (lastTracer instanceof IdentityTracer && ((IdentityTracer)lastTracer).getIdentityHashCode() == identityHashCode) {
            if (Agent.isDebugEnabled()) {
                Agent.LOG.log(Level.FINER, "Skipping {0}.{1} invocation because a parent has us covered", new Object[]{servlet.getClass().getName(), sig.getMethodName()});
            }
            return null;
        }
        try {
            if (transaction.isAutoAppNamingEnabled() && transaction.getApplicationName() == null) {
                Object servletContext = ServletUtils.getServletContextFromServlet(servlet);
                TransactionUtils.setAppNameFromServletContext(transaction, servletContext);
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Exception in {0} handling {1}: {2}", ServletTracerFactory.class.getSimpleName(), sig, e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            }
            Agent.LOG.finer(MessageFormat.format(msg, e));
        }
        return new ServletTracer(null, transaction, sig, servlet, args, identityHashCode);
    }
}

