/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.org.json.simple.JSONValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class JSON {
    public static final String nullValue() {
        return "null";
    }

    public static Number serializeNumber(Number n) {
        if (n instanceof NumberWrapper || n instanceof Integer) {
            return n;
        }
        return new NumberWrapper(n);
    }

    public static String toJSONString(Object obj) {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(oStream);
        try {
            JSONValue.writeJSONString(obj, writer);
            ((Writer)writer).close();
            return oStream.toString();
        }
        catch (IOException e) {
            return JSONValue.toJSONString(obj);
        }
    }

    private static final class NumberWrapper
    extends Number {
        private final Number n;
        private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);

        private NumberWrapper(Number n) {
            this.n = n;
        }

        public double doubleValue() {
            return this.n.doubleValue();
        }

        public float floatValue() {
            return this.n.floatValue();
        }

        public int intValue() {
            return this.n.intValue();
        }

        public long longValue() {
            return this.n.longValue();
        }

        public String toString() {
            return new DecimalFormat("#######################.#######################", decimalFormatSymbols).format(this.n.doubleValue());
        }
    }
}

