/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.util.Invoker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtils {
    private static final int PARAMETER_VALUE_MAX_LENGTH = 2048;
    private static final String SERVLET_INTERFACE = "javax.servlet.Servlet";
    private static final String SERVLET_CONFIG_INTERFACE = "javax.servlet.ServletConfig";
    private static final String FILTER_CONFIG_INTERFACE = "javax.servlet.FilterConfig";
    private static final String SERVLET_CONTEXT_INTERFACE = "javax.servlet.ServletContext";
    private static final String SERVLET_REQUEST_INTERFACE = "javax.servlet.ServletRequest";
    private static final String GET_SERVLET_CONTEXT_METHOD_NAME = "getServletContext";
    private static final String GET_SERVER_INFO_METHOD_NAME = "getServerInfo";
    private static final String GET_SERVLET_CONTEXT_NAME_METHOD_NAME = "getServletContextName";
    private static final String GET_CONTEXT_PATH_METHOD_NAME = "getContextPath";
    private static final String GET_MAJOR_VERSION_METHOD_NAME = "getMajorVersion";

    private ServletUtils() {
    }

    public static Object getServletContextFromServlet(Object servlet) throws Exception {
        Object config = Invoker.invoke(servlet, SERVLET_INTERFACE, "getServletConfig", new Object[0]);
        return ServletUtils.getServletContextFromServletConfig(config);
    }

    public static Map<String, String> getSimpleParameterMap(Map<String, String[]> parameterMap) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String value;
            String name = entry.getKey();
            String[] values = entry.getValue();
            String string = value = values.length == 1 ? values[0] : Arrays.asList(values).toString();
            if (value.length() > 2048) {
                value = value.substring(2048);
            }
            parameters.put(name, value);
        }
        return parameters;
    }

    public static void storeParameterMap(Map<String, String[]> parameterMap, Transaction transaction) {
        Map<String, String> requestParameters = ServletUtils.getSimpleParameterMap(parameterMap);
        if (!requestParameters.isEmpty()) {
            transaction.getParameters().put("request_parameters", requestParameters);
        }
    }

    public static Object getServletContextFromServletRequest(Object servletRequest) throws Exception {
        return Invoker.invoke(servletRequest, SERVLET_REQUEST_INTERFACE, GET_SERVLET_CONTEXT_METHOD_NAME, new Object[0]);
    }

    public static Object getServletContextFromServletConfig(Object servletConfig) throws Exception {
        if (servletConfig != null) {
            return Invoker.invoke(servletConfig, SERVLET_CONFIG_INTERFACE, GET_SERVLET_CONTEXT_METHOD_NAME, new Object[0]);
        }
        return null;
    }

    public static Object getServletContextFromFilterConfig(Object filterConfig) throws Exception {
        return Invoker.invoke(filterConfig, FILTER_CONFIG_INTERFACE, GET_SERVLET_CONTEXT_METHOD_NAME, new Object[0]);
    }

    public static String getServletInfoFromServletContext(Object servletContext) throws Exception {
        if (servletContext != null) {
            return (String)Invoker.invoke(servletContext, SERVLET_CONTEXT_INTERFACE, GET_SERVER_INFO_METHOD_NAME, new Object[0]);
        }
        return null;
    }

    public static String getServletContextNameFromServletContext(Object servletContext) throws Exception {
        Object application;
        if (servletContext != null && (application = Invoker.invoke(servletContext, SERVLET_CONTEXT_INTERFACE, GET_SERVLET_CONTEXT_NAME_METHOD_NAME, new Object[0])) != null) {
            return (String)application;
        }
        return null;
    }

    public static int getMajorVersion(Object servletContext) throws Exception {
        return (Integer)Invoker.invoke(servletContext, SERVLET_CONTEXT_INTERFACE, GET_MAJOR_VERSION_METHOD_NAME, new Object[0]);
    }

    public static String getContextPathFromServletContext(Object servletContext) throws Exception {
        if (servletContext != null) {
            return (String)Invoker.invoke(servletContext, SERVLET_CONTEXT_INTERFACE, GET_CONTEXT_PATH_METHOD_NAME, new Object[0]);
        }
        return null;
    }

    public static Map getFilteredParameterMap(Map params, Set<String> excludes) {
        if (excludes.isEmpty()) {
            return params;
        }
        params = new HashMap(params);
        for (String exclude : excludes) {
            params.remove(exclude);
        }
        return params;
    }
}

