/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.yaml.snakeyaml.constructor;

import com.newrelic.org.yaml.snakeyaml.composer.Composer;
import com.newrelic.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.org.yaml.snakeyaml.constructor.ConstructorException;
import com.newrelic.org.yaml.snakeyaml.nodes.MappingNode;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.ScalarNode;
import com.newrelic.org.yaml.snakeyaml.nodes.SequenceNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConstructor {
    protected final Map<String, Construct> yamlConstructors = new HashMap<String, Construct>();
    private Composer composer;
    private final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Map<Node, Object> recursiveObjects = new HashMap<Node, Object>();
    protected Class<? extends Object> rootType = Object.class;

    public void setComposer(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        this.composer.checkNode();
        Node node = this.composer.getNode();
        node.setType(this.rootType);
        return this.constructDocument(node);
    }

    public Object getSingleData() {
        Node node = this.composer.getSingleNode();
        if (node != null) {
            node.setType(this.rootType);
            return this.constructDocument(node);
        }
        return null;
    }

    private Object constructDocument(Node node) {
        Object data = this.constructObject(node);
        this.constructedObjects.clear();
        this.recursiveObjects.clear();
        return data;
    }

    protected Object constructObject(Node node) {
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        if (this.recursiveObjects.containsKey(node)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark());
        }
        this.recursiveObjects.put(node, null);
        Object data = this.callConstructor(node);
        this.constructedObjects.put(node, data);
        this.recursiveObjects.remove(node);
        return data;
    }

    protected Object callConstructor(Node node) {
        Object data = null;
        Construct constructor = null;
        constructor = this.yamlConstructors.get(node.getTag());
        if (constructor == null) {
            constructor = this.yamlConstructors.get(null);
            data = constructor.construct(node);
        } else {
            data = constructor.construct(node);
        }
        return data;
    }

    protected Object constructScalar(ScalarNode node) {
        return node.getValue();
    }

    protected List<Object> createDefaultList(int initSize) {
        return new LinkedList<Object>();
    }

    protected List<? extends Object> constructSequence(SequenceNode node) {
        Object nodeValue = node.getValue();
        List<Object> result = this.createDefaultList(nodeValue.size());
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node child = (Node)i$.next();
            result.add(this.constructObject(child));
        }
        return result;
    }

    protected Map<Object, Object> createDefaultMap() {
        return new LinkedHashMap<Object, Object>();
    }

    protected Map<Object, Object> constructMapping(MappingNode node) {
        Map<Object, Object> mapping = this.createDefaultMap();
        Object nodeValue = node.getValue();
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node[] tuple = (Node[])i$.next();
            Node keyNode = tuple[0];
            Node valueNode = tuple[1];
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple[0].getStartMark());
                }
            }
            Object value = this.constructObject(valueNode);
            mapping.put(key, value);
        }
        return mapping;
    }
}

