/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.org.yaml.snakeyaml.constructor;

import com.newrelic.org.yaml.snakeyaml.TypeDescription;
import com.newrelic.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.org.yaml.snakeyaml.constructor.ConstructorException;
import com.newrelic.org.yaml.snakeyaml.constructor.SafeConstructor;
import com.newrelic.org.yaml.snakeyaml.error.YAMLException;
import com.newrelic.org.yaml.snakeyaml.introspector.FieldProperty;
import com.newrelic.org.yaml.snakeyaml.introspector.MethodProperty;
import com.newrelic.org.yaml.snakeyaml.introspector.Property;
import com.newrelic.org.yaml.snakeyaml.nodes.MappingNode;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.ScalarNode;
import com.newrelic.org.yaml.snakeyaml.nodes.SequenceNode;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends SafeConstructor {
    private final Map<String, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    public Constructor(Class<? extends Object> theRoot) {
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstuctYamlObject());
        this.rootType = theRoot;
        this.typeTags = new HashMap<String, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
    }

    public Constructor(String theRoot) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)));
    }

    private static final String check(String s) {
        if (s == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (s.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return s;
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        if (this.rootType == Object.class && definition.isRoot()) {
            this.rootType = definition.getType();
        }
        String tag = definition.getTag();
        this.typeTags.put(tag, definition.getType());
        return this.typeDefinitions.put(definition.getType(), definition);
    }

    @Override
    protected Object callConstructor(Node node) {
        Object result;
        if (Object.class.equals(node.getType())) {
            return super.callConstructor(node);
        }
        switch (node.getNodeId()) {
            case scalar: {
                result = this.constructScalarNode((ScalarNode)node);
                break;
            }
            case sequence: {
                result = this.constructSequence((SequenceNode)node);
                break;
            }
            default: {
                result = Map.class.isAssignableFrom(node.getType()) ? super.constructMapping((MappingNode)node) : this.constructMappingNode((MappingNode)node);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object constructScalarNode(ScalarNode node) {
        Class<? extends Object> type = node.getType();
        if (type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || type == Date.class || type == Character.class || type == BigInteger.class || Enum.class.isAssignableFrom(type)) {
            Object result;
            if (type == String.class) {
                Construct stringContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:str");
                return stringContructor.construct(node);
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                Construct boolContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:bool");
                return boolContructor.construct(node);
            }
            if (type == Character.class || type == Character.TYPE) {
                Construct charContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:str");
                String ch = (String)charContructor.construct(node);
                if (ch.length() == 1) return new Character(ch.charAt(0));
                throw new YAMLException("Invalid node Character: '" + ch + "'; length: " + ch.length());
            }
            if (type == Date.class) {
                Construct dateContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:timestamp");
                return dateContructor.construct(node);
            }
            if (type == Float.class || type == Double.class || type == Float.TYPE || type == Double.TYPE) {
                Construct doubleContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:float");
                result = doubleContructor.construct(node);
                if (type == Float.class) return new Float((Double)result);
                if (type != Float.TYPE) return result;
                return new Float((Double)result);
            }
            if (Number.class.isAssignableFrom(type) || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE) {
                Construct intContructor = (Construct)this.yamlConstructors.get("tag:yaml.org,2002:int");
                result = intContructor.construct(node);
                if (type == Byte.class) return new Byte(result.toString());
                if (type == Byte.TYPE) {
                    return new Byte(result.toString());
                }
                if (type == Short.class) return new Short(result.toString());
                if (type == Short.TYPE) {
                    return new Short(result.toString());
                }
                if (type == Integer.class) return new Integer(result.toString());
                if (type == Integer.TYPE) {
                    return new Integer(result.toString());
                }
                if (type == Long.class) return new Long(result.toString());
                if (type == Long.TYPE) {
                    return new Long(result.toString());
                }
                if (type != BigInteger.class) throw new YAMLException("Unsupported Number class: " + type);
                return new BigInteger(result.toString());
            }
            if (!Enum.class.isAssignableFrom(type)) throw new YAMLException("Unsupported class: " + type);
            String tag = "tag:yaml.org,2002:" + type.getName();
            node.setTag(tag);
            return super.callConstructor(node);
        }
        try {
            Object value = super.callConstructor(node);
            if (type.isArray()) {
                return value;
            }
            java.lang.reflect.Constructor<? extends Object> javaConstructor = type.getConstructor(value.getClass());
            return javaConstructor.newInstance(value);
        }
        catch (Exception e) {
            throw new YAMLException(e);
        }
    }

    private Object constructMappingNode(MappingNode node) {
        Object object;
        Class<? extends Object> beanType = node.getType();
        try {
            object = beanType.newInstance();
        }
        catch (InstantiationException e) {
            throw new YAMLException(e);
        }
        catch (IllegalAccessException e) {
            throw new YAMLException(e);
        }
        Object nodeValue = node.getValue();
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node[] tuple = (Node[])i$.next();
            if (!(tuple[0] instanceof ScalarNode)) {
                throw new YAMLException("Keys must be scalars but found: " + tuple[0]);
            }
            ScalarNode keyNode = (ScalarNode)tuple[0];
            Node valueNode = tuple[1];
            keyNode.setType(String.class);
            String key = (String)this.constructObject(keyNode);
            boolean isArray = false;
            try {
                Property property = this.getProperty(beanType, key);
                if (property == null) {
                    throw new YAMLException("Unable to find property '" + key + "' on class: " + beanType.getName());
                }
                valueNode.setType(property.getType());
                TypeDescription memberDescription = this.typeDefinitions.get(beanType);
                if (memberDescription != null) {
                    switch (valueNode.getNodeId()) {
                        case sequence: {
                            SequenceNode snode = (SequenceNode)valueNode;
                            Class<? extends Object> memberType = memberDescription.getListPropertyType(key);
                            if (memberType != null) {
                                snode.setListType(memberType);
                                break;
                            }
                            if (!property.getType().isArray()) break;
                            isArray = true;
                            snode.setListType(property.getType().getComponentType());
                            break;
                        }
                        case mapping: {
                            MappingNode mnode = (MappingNode)valueNode;
                            Class<? extends Object> keyType = memberDescription.getMapKeyType(key);
                            if (keyType == null) break;
                            mnode.setKeyType(keyType);
                            mnode.setValueType(memberDescription.getMapValueType(key));
                        }
                    }
                }
                Object[] value = this.constructObject(valueNode);
                if (isArray) {
                    List list = (List)value;
                    value = list.toArray(this.createArray(property.getType()));
                }
                property.set(object, value);
            }
            catch (Exception e) {
                throw new YAMLException(e);
            }
        }
        return object;
    }

    private <T> T[] createArray(Class<T> type) {
        return (Object[])Array.newInstance(type.getComponentType(), 0);
    }

    protected Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
        for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (!property.getName().equals(name)) continue;
            if (property.getReadMethod() == null || property.getWriteMethod() == null) break;
            return new MethodProperty(property);
        }
        for (Field field : type.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !field.getName().equals(name)) continue;
            return new FieldProperty(field);
        }
        return null;
    }

    private class ConstuctYamlObject
    implements Construct {
        private ConstuctYamlObject() {
        }

        public Object construct(Node node) {
            Object result = null;
            Class<?> customTag = (Class<?>)Constructor.this.typeTags.get(node.getTag());
            try {
                Class<?> cl;
                if (customTag == null) {
                    if (node.getTag().length() < "tag:yaml.org,2002:".length()) {
                        throw new YAMLException("Unknown tag: " + node.getTag());
                    }
                    String name = node.getTag().substring("tag:yaml.org,2002:".length());
                    cl = Class.forName(name);
                } else {
                    cl = customTag;
                }
                switch (node.getNodeId()) {
                    case mapping: {
                        MappingNode mnode = (MappingNode)node;
                        mnode.setType((Class<? extends Object>)cl);
                        result = Constructor.this.constructMappingNode(mnode);
                        break;
                    }
                    case sequence: {
                        SequenceNode seqNode = (SequenceNode)node;
                        List<? extends Object> values = Constructor.this.constructSequence(seqNode);
                        Class[] parameterTypes = new Class[values.size()];
                        int index = 0;
                        for (Object object : values) {
                            parameterTypes[index] = object.getClass();
                            ++index;
                        }
                        java.lang.reflect.Constructor<?> javaConstructor = cl.getConstructor(parameterTypes);
                        Object[] initargs = values.toArray();
                        result = javaConstructor.newInstance(initargs);
                        break;
                    }
                    default: {
                        ScalarNode scalarNode = (ScalarNode)node;
                        Object value = Constructor.this.constructScalar(scalarNode);
                        if (Enum.class.isAssignableFrom(cl)) {
                            String enumValueName = (String)node.getValue();
                            try {
                                result = Enum.valueOf(cl, enumValueName);
                                break;
                            }
                            catch (Exception ex) {
                                throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + cl.getName());
                            }
                        }
                        java.lang.reflect.Constructor<?> javaConstructor = cl.getConstructor(value.getClass());
                        result = javaConstructor.newInstance(value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark());
            }
            return result;
        }
    }
}

