/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyMsgExtractor {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyMsgExtractor  \\\n     [<flag1> <flag2> ...] --outputFile <path>  \\\n     <soyFile1> <soyFile2> ...\n";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--outputFile", required=true, usage="[Required] The path to the output file to write. If a file already exists at this location, it will be overwritten. The file extension must match the output format requested.")
    private String outputFile = "";
    @Option(name="--sourceLocaleString", usage="The locale string of the source language (default 'en').")
    private String sourceLocaleString = "en";
    @Option(name="--targetLocaleString", usage="The locale string of the target language (default empty). If empty, then the output messages file will not specify a target locale string. Note that this option may not be applicable for certain message plugins (in which case this value will be ignored by the message plugin).")
    private String targetLocaleString = "";
    @Option(name="--messagePluginModule", usage="Specifies the full class name of a Guice module that binds a SoyMsgPlugin. If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule, which binds the XliffMsgPlugin.")
    private String messagePluginModule = XliffMsgPluginModule.class.getName();
    @Argument
    private List<String> arguments = Lists.newArrayList();

    public static void main(String[] stringArray) throws IOException {
        new SoyMsgExtractor().execMain(stringArray);
    }

    private SoyMsgExtractor() {
    }

    private void execMain(String[] stringArray) throws IOException, SoySyntaxException {
        CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, stringArray, USAGE_PREFIX);
        if (this.arguments.size() == 0) {
            MainClassUtils.exitWithError("Must provide list of Soy files.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.outputFile.length() == 0) {
            MainClassUtils.exitWithError("Must provide output file path.", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = MainClassUtils.createInjector(this.messagePluginModule, null);
        SoyFileSet.Builder builder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        String string = this.inputPrefix;
        for (String object2 : this.arguments) {
            builder.add(new File(string + object2));
        }
        SoyFileSet soyFileSet = builder.build();
        SoyMsgBundle soyMsgBundle = soyFileSet.extractMsgs();
        SoyMsgBundleHandler soyMsgBundleHandler = (SoyMsgBundleHandler)injector.getInstance(SoyMsgBundleHandler.class);
        SoyMsgBundleHandler.OutputFileOptions outputFileOptions = new SoyMsgBundleHandler.OutputFileOptions();
        outputFileOptions.setSourceLocaleString(this.sourceLocaleString);
        if (this.targetLocaleString.length() > 0) {
            outputFileOptions.setTargetLocaleString(this.targetLocaleString);
        }
        soyMsgBundleHandler.writeToFile(soyMsgBundle, outputFileOptions, new File(this.outputFile));
    }
}

