/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.template.soy.MainClassUtils;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class SoyToJsSrcCompiler {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.SoyToJsSrcCompiler  \\\n     [<flag1> <flag2> ...] --outputPathFormat <formatString>  \\\n     <soyFile1> <soyFile2> ...\n";
    @Option(name="--inputPrefix", usage="If provided, this path prefix will be prepended to each input file path listed on the command line. This is a literal string prefix, so you'll need to include a trailing slash if necessary.")
    private String inputPrefix = "";
    @Option(name="--outputPathFormat", required=true, usage="[Required] A format string that specifies how to build the path to each output file. If not generating localized JS, then there will be one output JS file (UTF-8) for each input Soy file. If generating localized JS, then there will be one output JS file for each combination of input Soy file and locale. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {INPUT_DIRECTORY}, {INPUT_FILE_NAME}, {INPUT_FILE_NAME_NO_EXT}, {LOCALE}, {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br.")
    private String outputPathFormat = "";
    @Option(name="--codeStyle", usage="The code style to use when generating JS code ('stringbuilder' or 'concat').")
    private SoyJsSrcOptions.CodeStyle codeStyle = SoyJsSrcOptions.CodeStyle.STRINGBUILDER;
    @Option(name="--shouldGenerateJsdoc", usage="Whether we should generate JSDoc with type info for the Closure Compiler. Note the generated JSDoc does not have description text, only types for the benefit of the Closure Compiler.")
    private boolean shouldGenerateJsdoc = false;
    @Option(name="--shouldProvideRequireSoyNamespaces", usage="When this option is used, each generated JS file will contain (a) one single goog.provide statement for the corresponding Soy file's namespace and (b) goog.require statements for the namespaces of the called templates.")
    private boolean shouldProvideRequireSoyNamespaces = false;
    @Option(name="--shouldDeclareTopLevelNamespaces", usage="[Only applicable when generating regular JS code to define namespaces (i.e. not generating goog.provide/goog.require).] When this option is set to false, each generated JS file will not attempt to declare the top-level name in its namespace, instead assuming the top-level name is already declared in the global scope. E.g. for namespace aaa.bbb, the code will not attempt to declare aaa, but will still define aaa.bbb if it's not already defined.")
    private boolean shouldDeclareTopLevelNamespaces = true;
    @Option(name="--locales", usage="[Required for generating localized JS] Comma-delimited list of locales for which to generate localized JS. There will be one output JS file for each combination of input Soy file and locale.", handler=MainClassUtils.StringListOptionHandler.class)
    private List<String> locales = Lists.newArrayList();
    @Option(name="--messageFilePathFormat", usage="[Required for generating localized JS] A format string that specifies how to build the path to each translated messages file. The format string can include literal characters as well as the placeholders {INPUT_PREFIX}, {LOCALE}, and {LOCALE_LOWER_CASE}. Note {LOCALE_LOWER_CASE} also turns dash into underscore, e.g. pt-BR becomes pt_br. The format string must end with an extension matching the message file format (case-insensitive).")
    private String messageFilePathFormat = "";
    @Option(name="--bidiGlobalDir", usage="The bidi global directionality (ltr=1, rtl=-1) to use when processing bidi functions/directives. Only applicable if your Soy code uses bidi functions/directives. Also note that this flag is usually not necessary if a message file is provided, because in that case the bidi global directionality is simply inferred from the message bundle.")
    private int bidiGlobalDir = 0;
    @Option(name="--cssHandlingScheme", usage="The scheme to use for handling 'css' commands. Specifying 'literal' will cause command text to be inserted as literal text. Specifying 'reference' will cause command text to be evaluated as a data or global reference. Specifying 'goog' will cause generation of calls goog.getCssName. This option has no effect if the Soy code does not contain 'css' commands.")
    private String cssHandlingScheme = "literal";
    @Option(name="--compileTimeGlobalsFile", usage="The path to a file containing the mappings for global names to be substituted at compile time. Each line of the file should have the format \"<global_name> = <primitive_data>\" where primitive_data is a valid Soy expression literal for a primitive type (null, boolean, integer, float, or string). Empty lines and lines beginning with \"//\" are ignored. The file should be encoded in UTF-8. If you need to generate a file in this format from Java, consider using the utility SoyUtils.generateCompileTimeGlobalsFile().")
    private String compileTimeGlobalsFile = "";
    @Option(name="--messagePluginModule", usage="Specifies the full class name of a Guice module that binds a SoyMsgPlugin. If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPluginModule, which binds the XliffMsgPlugin.")
    private String messagePluginModule = XliffMsgPluginModule.class.getName();
    @Option(name="--pluginModules", usage="Specifies the full class names of Guice modules for function plugins and print directive plugins (comma-delimited list).")
    private String pluginModules = "";
    @Argument
    private List<String> arguments = Lists.newArrayList();

    public static void main(String[] stringArray) throws IOException, SoySyntaxException {
        new SoyToJsSrcCompiler().execMain(stringArray);
    }

    private SoyToJsSrcCompiler() {
    }

    private void execMain(String[] stringArray) throws IOException, SoySyntaxException {
        CmdLineParser cmdLineParser = MainClassUtils.parseFlags(this, stringArray, USAGE_PREFIX);
        if (this.arguments.size() == 0) {
            MainClassUtils.exitWithError("Must provide list of Soy files.", cmdLineParser, USAGE_PREFIX);
        }
        if (this.outputPathFormat.length() == 0) {
            MainClassUtils.exitWithError("Must provide the output path format.", cmdLineParser, USAGE_PREFIX);
        }
        Injector injector = MainClassUtils.createInjector(this.messagePluginModule, this.pluginModules);
        SoyJsSrcOptions soyJsSrcOptions = new SoyJsSrcOptions();
        soyJsSrcOptions.setCodeStyle(this.codeStyle);
        soyJsSrcOptions.setShouldGenerateJsdoc(this.shouldGenerateJsdoc);
        soyJsSrcOptions.setShouldProvideRequireSoyNamespaces(this.shouldProvideRequireSoyNamespaces);
        soyJsSrcOptions.setShouldDeclareTopLevelNamespaces(this.shouldDeclareTopLevelNamespaces);
        soyJsSrcOptions.setBidiGlobalDir(this.bidiGlobalDir);
        SoyFileSet.Builder builder = (SoyFileSet.Builder)injector.getInstance(SoyFileSet.Builder.class);
        String string = this.inputPrefix;
        for (String object2 : this.arguments) {
            builder.add(new File(string + object2));
        }
        String string2 = this.cssHandlingScheme.toUpperCase();
        builder.setCssHandlingScheme(string2.equals("GOOG") ? SoyGeneralOptions.CssHandlingScheme.BACKEND_SPECIFIC : SoyGeneralOptions.CssHandlingScheme.valueOf(string2));
        if (this.compileTimeGlobalsFile.length() > 0) {
            builder.setCompileTimeGlobals(new File(this.compileTimeGlobalsFile));
        }
        SoyFileSet soyFileSet = builder.build();
        if (this.locales.size() == 0) {
            soyFileSet.compileToJsSrcFiles(this.outputPathFormat, this.inputPrefix, soyJsSrcOptions, this.locales, null);
        } else {
            soyFileSet.compileToJsSrcFiles(this.outputPathFormat, this.inputPrefix, soyJsSrcOptions, this.locales, this.messageFilePathFormat);
        }
    }
}

