/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractNodeVisitor<N extends Node, R>
implements NodeVisitor<N, R> {
    private static Map<Class<? extends AbstractNodeVisitor>, Map> concreteVisitorClassToCachedMap = Maps.newHashMap();
    private final List<Class<? extends N>> nodeClasses;
    private final List<Class<? extends N>> nodeInterfaces;
    private Map<Class<? extends N>, Method> classToMethodMap = null;

    protected AbstractNodeVisitor(List<Class<? extends N>> list, List<Class<? extends N>> list2) {
        this.nodeClasses = list;
        this.nodeInterfaces = list2;
    }

    @Override
    public R exec(N n) {
        this.setup();
        this.visit(n);
        return this.getResult();
    }

    protected void setup() {
    }

    protected void visit(N n) {
        Object object;
        if (this.classToMethodMap == null) {
            object = concreteVisitorClassToCachedMap.get(this.getClass());
            if (object != null) {
                this.classToMethodMap = object;
            } else {
                this.classToMethodMap = this.buildClassToMethodMap();
                concreteVisitorClassToCachedMap.put(this.getClass(), this.classToMethodMap);
            }
        }
        if ((object = this.classToMethodMap.get(n.getClass())) == null) {
            throw new UnsupportedOperationException("Node visitor " + this.getClass().getSimpleName() + " is not implemented for class " + n.getClass().getSimpleName() + ".");
        }
        try {
            ((Method)object).invoke((Object)this, n);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwables.propagate((Throwable)invocationTargetException.getCause());
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
    }

    protected R getResult() {
        return null;
    }

    private Map<Class<? extends N>, Method> buildClassToMethodMap() {
        HashMap hashMap = Maps.newHashMap();
        block0: for (Class<? extends N> clazz : this.nodeClasses) {
            Method method = this.getMethodNamedVisitInternal(clazz);
            if (method != null) {
                hashMap.put(clazz, method);
                continue;
            }
            for (Class<N> clazz2 : this.nodeInterfaces) {
                Method method2;
                if (!clazz2.isAssignableFrom(clazz) || (method2 = this.getMethodNamedVisitInternal(clazz2)) == null) continue;
                hashMap.put(clazz, method2);
                continue block0;
            }
            hashMap.put(clazz, null);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private Method getMethodNamedVisitInternal(Class<? extends N> clazz) {
        Class<?> clazz2 = this.getClass();
        while (clazz2.getSuperclass() != AbstractNodeVisitor.class) {
            try {
                Method method = clazz2.getDeclaredMethod("visitInternal", clazz);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = clazz2.getSuperclass();
            }
        }
        return null;
    }
}

