/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

@Singleton
public class ChangeNewlineToBrDirective
implements SoyTofuPrintDirective,
SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n)");

    @Inject
    public ChangeNewlineToBrDirective() {
    }

    @Override
    public String getName() {
        return "|changeNewlineToBr";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String applyForTofu(String string, List<SoyData> list) {
        return NEWLINE_PATTERN.matcher(string).replaceAll("<br>");
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        return new JsExpr("soy.$$changeNewlineToBr(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$changeNewlineToBr", javaExpr.getText()), String.class, Integer.MAX_VALUE);
    }
}

