/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class InsertWordBreaksDirective
implements SoyTofuPrintDirective,
SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    @Inject
    InsertWordBreaksDirective() {
    }

    @Override
    public String getName() {
        return "|insertWordBreaks";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String applyForTofu(String string, List<SoyData> list) {
        int n;
        int n2;
        try {
            n2 = list.get(0).integerValue();
        }
        catch (SoyDataException soyDataException) {
            throw new IllegalArgumentException("Could not parse 'insertWordBreaks' parameter as integer.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n3 >= n2 && n != 32) {
                stringBuilder.append("<wbr>");
                n3 = 0;
            }
            if (bl) {
                if (n == 62) {
                    bl = false;
                }
            } else if (bl2) {
                switch (n) {
                    case 59: {
                        bl2 = false;
                        ++n3;
                        break;
                    }
                    case 60: {
                        bl2 = false;
                        bl = true;
                        break;
                    }
                    case 32: {
                        bl2 = false;
                        n3 = 0;
                    }
                }
            } else {
                switch (n) {
                    case 60: {
                        bl = true;
                        break;
                    }
                    case 38: {
                        bl2 = true;
                        break;
                    }
                    case 32: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        ++n3;
                    }
                }
            }
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        return new JsExpr("soy.$$insertWordBreaks(" + jsExpr.getText() + ", " + list.get(0).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$insertWordBreaks", javaExpr.getText(), list.get(0).getText()), String.class, Integer.MAX_VALUE);
    }
}

