/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.tofu.restricted.SoyTofuFunction;
import com.google.template.soy.tofu.restricted.SoyTofuFunctionUtils;
import java.util.List;
import java.util.Set;

@Singleton
class BidiMarkAfterFunction
implements SoyTofuFunction,
SoyJsSrcFunction {
    private final Provider<Integer> bidiGlobalDirProvider;

    @Inject
    BidiMarkAfterFunction(@ApiCallScopeBindingAnnotations.BidiGlobalDir Provider<Integer> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "bidiMarkAfter";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData computeForTofu(List<SoyData> list) {
        String string = list.get(0).stringValue();
        boolean bl = list.size() == 2 ? list.get(1).booleanValue() : false;
        int n = (Integer)this.bidiGlobalDirProvider.get();
        return SoyTofuFunctionUtils.toSoyData(SoyBidiUtils.getBidiFormatter(n).markAfter(string, bl));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        JsExpr jsExpr2 = list.size() == 2 ? list.get(1) : null;
        String string = "soy.$$bidiMarkAfter(" + this.bidiGlobalDirProvider.get() + ", " + jsExpr.getText() + (jsExpr2 != null ? ", " + jsExpr2.getText() : "") + ")";
        return new JsExpr(string, Integer.MAX_VALUE);
    }
}

