/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class EscapeHtmlDirective
implements SoyTofuPrintDirective,
SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    public static final String NAME = "|escapeHtml";

    @Inject
    public EscapeHtmlDirective() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public String applyForTofu(String string, List<SoyData> list) {
        return CharEscapers.asciiHtmlEscaper().escape(string);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        return new JsExpr("soy.$$escapeHtml(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$escapeHtml", javaExpr.getText()), String.class, Integer.MAX_VALUE);
    }
}

