/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.restricted.CollectionData;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;

public class SoyMapData
extends CollectionData {
    private final Map<String, SoyData> map = Maps.newHashMap();
    private static final Pattern KEY_PATTERN = Pattern.compile("[A-Za-z_][A-Za-z_0-9]*");

    public SoyMapData() {
    }

    public SoyMapData(Map<String, ?> map) {
        this();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string;
            try {
                string = entry.getKey();
            }
            catch (ClassCastException classCastException) {
                throw new SoyDataException("Attempting to convert a map with non-string key to Soy data (key type " + entry.getKey().getClass().getSimpleName() + ").");
            }
            this.checkKey(string);
            Object obj = entry.getValue();
            this.map.put(string, SoyData.createFromExistingData(obj));
        }
    }

    public SoyMapData(Object ... objectArray) {
        this();
        this.put(objectArray);
    }

    public Map<String, SoyData> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this.map);
    }

    protected String toStringHelper(Map<String, SoyData> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        for (Map.Entry<String, SoyData> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    protected void checkKey(String string) throws IllegalArgumentException {
        if (!KEY_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("Illegal data key '" + string + "' for map data.");
        }
    }

    @Override
    protected void putSingle(String string, SoyData soyData) {
        this.map.put(string, soyData);
    }

    @Override
    protected void removeSingle(String string) {
        this.map.remove(string);
    }

    @Override
    protected SoyData getSingle(String string) {
        return this.map.get(string);
    }
}

