/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.base;

import com.google.common.base.Preconditions;
import com.google.template.soy.internal.base.Escaper;
import java.io.IOException;

public abstract class CharEscaper
implements Escaper {
    private static final int DEST_PAD = 32;
    private static final ThreadLocal<char[]> DEST_TL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[1024];
        }
    };

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull((Object)string);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.escape(string.charAt(i)) == null) continue;
            return this.escapeSlow(string, i);
        }
        return string;
    }

    @Override
    public Appendable escape(final Appendable appendable) {
        Preconditions.checkNotNull((Object)appendable);
        return new Appendable(){

            @Override
            public Appendable append(CharSequence charSequence) throws IOException {
                appendable.append(CharEscaper.this.escape(((Object)charSequence).toString()));
                return this;
            }

            @Override
            public Appendable append(CharSequence charSequence, int n, int n2) throws IOException {
                appendable.append(CharEscaper.this.escape(((Object)charSequence.subSequence(n, n2)).toString()));
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                char[] cArray = CharEscaper.this.escape(c);
                if (cArray == null) {
                    appendable.append(c);
                } else {
                    for (char c2 : cArray) {
                        appendable.append(c2);
                    }
                }
                return this;
            }
        };
    }

    protected String escapeSlow(String string, int n) {
        int n2;
        int n3 = string.length();
        char[] cArray = DEST_TL.get();
        int n4 = cArray.length;
        int n5 = 0;
        int n6 = 0;
        while (n < n3) {
            char[] cArray2 = this.escape(string.charAt(n));
            if (cArray2 != null) {
                int n7 = n - n6;
                n2 = cArray2.length;
                int n8 = n5 + n7 + n2;
                if (n4 < n8) {
                    n4 = n8 + (n3 - n) + 32;
                    cArray = CharEscaper.growBuffer(cArray, n5, n4);
                }
                if (n7 > 0) {
                    string.getChars(n6, n, cArray, n5);
                    n5 += n7;
                }
                if (n2 > 0) {
                    System.arraycopy(cArray2, 0, cArray, n5, n2);
                    n5 += n2;
                }
                n6 = n + 1;
            }
            ++n;
        }
        int n9 = n3 - n6;
        if (n9 > 0) {
            n2 = n5 + n9;
            if (n4 < n2) {
                cArray = CharEscaper.growBuffer(cArray, n5, n2);
            }
            string.getChars(n6, n3, cArray, n5);
            n5 = n2;
        }
        return new String(cArray, 0, n5);
    }

    protected abstract char[] escape(char var1);

    private static char[] growBuffer(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        if (n > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
        }
        return cArray2;
    }
}

