/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.javasrc.internal.GenCallCodeUtils;
import com.google.template.soy.javasrc.internal.GenJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.IsComputableAsJavaExprsVisitor;
import com.google.template.soy.javasrc.internal.JavaCodeBuilder;
import com.google.template.soy.javasrc.internal.TranslateToJavaExprVisitor;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.JavaExprUtils;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class GenJavaCodeVisitor
extends AbstractSoyNodeVisitor<String> {
    private static final Pattern INTEGER = Pattern.compile("-?\\d+");
    private final SoyJavaSrcOptions javaSrcOptions;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor;
    private final CanInitOutputVarVisitor canInitOutputVarVisitor;
    private final GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory;
    private final TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory;
    @VisibleForTesting
    protected GenJavaExprsVisitor genJavaExprsVisitor;
    @VisibleForTesting
    protected JavaCodeBuilder javaCodeBuilder;
    @VisibleForTesting
    protected Deque<Map<String, JavaExpr>> localVarTranslations;

    @Inject
    GenJavaCodeVisitor(SoyJavaSrcOptions soyJavaSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJavaExprsVisitor isComputableAsJavaExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenJavaExprsVisitor.GenJavaExprsVisitorFactory genJavaExprsVisitorFactory, TranslateToJavaExprVisitor.TranslateToJavaExprVisitorFactory translateToJavaExprVisitorFactory) {
        this.javaSrcOptions = soyJavaSrcOptions;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJavaExprsVisitor = isComputableAsJavaExprsVisitor;
        this.canInitOutputVarVisitor = canInitOutputVarVisitor;
        this.genJavaExprsVisitorFactory = genJavaExprsVisitorFactory;
        this.translateToJavaExprVisitorFactory = translateToJavaExprVisitorFactory;
    }

    @Override
    protected void setup() {
        this.javaCodeBuilder = new JavaCodeBuilder(this.javaSrcOptions.getCodeStyle());
        this.localVarTranslations = null;
    }

    @Override
    @VisibleForTesting
    protected void visit(SoyNode soyNode) {
        super.visit(soyNode);
    }

    @Override
    protected String getResult() {
        return this.javaCodeBuilder.getCode();
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        if (parentSoyNode.numChildren() == 0 || !((Boolean)this.canInitOutputVarVisitor.exec(parentSoyNode.getChild(0))).booleanValue()) {
            this.javaCodeBuilder.initOutputVarIfNecessary();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(soyNode)).booleanValue()) {
                arrayList.addAll(this.genJavaExprsVisitor.exec(soyNode));
                continue;
            }
            if (arrayList.size() > 0) {
                this.javaCodeBuilder.addToOutputVar(arrayList);
                arrayList.clear();
            }
            this.visit(soyNode);
        }
        if (arrayList.size() > 0) {
            this.javaCodeBuilder.addToOutputVar(arrayList);
            arrayList.clear();
        }
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        boolean bl = true;
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                this.javaCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            }
            try {
                this.visit(soyFileNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setFilePath(soyFileNode.getFilePath());
            }
        }
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.javaCodeBuilder.appendLine("// ----------------------------------------------------------------------------- ");
        this.javaCodeBuilder.appendLine("// The functions below were generated from ", soyFileNode.getFileName(), ".");
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            this.javaCodeBuilder.appendLine(new String[0]).appendLine(new String[0]);
            try {
                this.visit(templateNode);
            }
            catch (SoySyntaxException soySyntaxException) {
                throw soySyntaxException.setTemplateName(templateNode.getTemplateName());
            }
        }
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        boolean bl = this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER;
        this.localVarTranslations = new ArrayDeque<Map<String, JavaExpr>>();
        this.genJavaExprsVisitor = this.genJavaExprsVisitorFactory.create(this.localVarTranslations);
        if (bl) {
            this.javaCodeBuilder.appendLine(templateNode.isPrivate() ? "private" : "public", " static String ", templateNode.getTemplateName().replace('.', '$'), "(com.google.template.soy.data.SoyMapData data, StringBuilder sb) {");
        } else {
            this.javaCodeBuilder.appendLine(templateNode.isPrivate() ? "private" : "public", " static String ", templateNode.getTemplateName().replace('.', '$'), "(com.google.template.soy.data.SoyMapData data) {");
        }
        this.javaCodeBuilder.increaseIndent();
        this.localVarTranslations.push(Maps.newHashMap());
        if (!bl && ((Boolean)this.isComputableAsJavaExprsVisitor.exec(templateNode)).booleanValue()) {
            List<JavaExpr> list = this.genJavaExprsVisitor.exec(templateNode);
            JavaExpr javaExpr = JavaExprUtils.concatJavaExprs(list);
            this.javaCodeBuilder.appendLine("return ", javaExpr.getText(), ";");
        } else {
            this.javaCodeBuilder.pushOutputVar("output");
            if (bl) {
                this.javaCodeBuilder.appendLine("StringBuilder output = (sb != null) ? sb : new StringBuilder();");
                this.javaCodeBuilder.setOutputVarInited();
            }
            this.visitChildren(templateNode);
            if (bl) {
                this.javaCodeBuilder.appendLine("return (sb != null) ? null : output.toString();");
            } else {
                this.javaCodeBuilder.appendLine("return output;");
            }
            this.javaCodeBuilder.popOutputVar();
        }
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(ifNode)).booleanValue()) {
            this.javaCodeBuilder.addToOutputVar(this.genJavaExprsVisitor.exec(ifNode));
            return;
        }
        for (SoyNode soyNode : ifNode.getChildren()) {
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof IfCondNode) {
                abstractParentSoyCommandNode = (IfCondNode)soyNode;
                JavaExpr javaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(((IfCondNode)abstractParentSoyCommandNode).getExpr());
                if (abstractParentSoyCommandNode.getCommandName().equals("if")) {
                    this.javaCodeBuilder.appendLine("if (", JavaCodeUtils.genCoerceBoolean(javaExpr), ") {");
                } else {
                    this.javaCodeBuilder.appendLine("} else if (", JavaCodeUtils.genCoerceBoolean(javaExpr), ") {");
                }
                this.javaCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof IfElseNode) {
                abstractParentSoyCommandNode = (IfElseNode)soyNode;
                this.javaCodeBuilder.appendLine("} else {");
                this.javaCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        TranslateToJavaExprVisitor translateToJavaExprVisitor = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        JavaExpr javaExpr = (JavaExpr)translateToJavaExprVisitor.exec(switchNode.getExpr());
        String string = "switchValue" + switchNode.getId();
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyData ", string, " = ", javaExpr.getText(), ";");
        boolean bl = true;
        for (SoyNode soyNode : switchNode.getChildren()) {
            AbstractParentSoyCommandNode abstractParentSoyCommandNode;
            if (soyNode instanceof SwitchCaseNode) {
                abstractParentSoyCommandNode = (SwitchCaseNode)soyNode;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = true;
                for (ExprRootNode<ExprNode> exprRootNode : ((SwitchCaseNode)abstractParentSoyCommandNode).getExprList()) {
                    JavaExpr javaExpr2 = (JavaExpr)translateToJavaExprVisitor.exec(exprRootNode);
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(" || ");
                    }
                    stringBuilder.append(string).append(".equals(").append(javaExpr2.getText()).append(")");
                }
                if (bl) {
                    bl = false;
                    this.javaCodeBuilder.appendLine("if (", stringBuilder.toString(), ") {");
                } else {
                    this.javaCodeBuilder.appendLine("} else if (", stringBuilder.toString(), ") {");
                }
                this.javaCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            if (soyNode instanceof SwitchDefaultNode) {
                abstractParentSoyCommandNode = (SwitchDefaultNode)soyNode;
                this.javaCodeBuilder.appendLine("} else {");
                this.javaCodeBuilder.increaseIndent();
                this.visit(abstractParentSoyCommandNode);
                this.javaCodeBuilder.decreaseIndent();
                continue;
            }
            throw new AssertionError();
        }
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        boolean bl;
        String string = foreachNode.getVarName();
        String string2 = foreachNode.getId();
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        JavaExpr javaExpr = (JavaExpr)this.translateToJavaExprVisitorFactory.create(this.localVarTranslations).exec(foreachNode.getDataRef());
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyListData ", string3, " = (com.google.template.soy.data.SoyListData) ", javaExpr.getText(), ";");
        this.javaCodeBuilder.appendLine("int ", string4, " = ", string3, ".length();");
        boolean bl2 = bl = foreachNode.numChildren() == 2;
        if (bl) {
            this.javaCodeBuilder.appendLine("if (", string4, " > 0) {");
            this.javaCodeBuilder.increaseIndent();
        }
        this.visit((ForeachNonemptyNode)foreachNode.getChild(0));
        if (bl) {
            this.javaCodeBuilder.decreaseIndent();
            this.javaCodeBuilder.appendLine("} else {");
            this.javaCodeBuilder.increaseIndent();
            this.visit((ForeachIfemptyNode)foreachNode.getChild(1));
            this.javaCodeBuilder.decreaseIndent();
            this.javaCodeBuilder.appendLine("}");
        }
    }

    @Override
    protected void visitInternal(ForeachNonemptyNode foreachNonemptyNode) {
        String string = foreachNonemptyNode.getVarName();
        String string2 = foreachNonemptyNode.getForeachNodeId();
        String string3 = string + "List" + string2;
        String string4 = string + "ListLen" + string2;
        String string5 = string + "Index" + string2;
        String string6 = string + "Data" + string2;
        this.javaCodeBuilder.appendLine("for (int ", string5, " = 0; ", string5, " < ", string4, "; ", string5, "++) {");
        this.javaCodeBuilder.increaseIndent();
        this.javaCodeBuilder.appendLine("com.google.template.soy.data.SoyData ", string6, " = ", string3, ".get(", string5, ");");
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string, new JavaExpr(string6, SoyData.class, Integer.MAX_VALUE));
        hashMap.put(string + "__isFirst", new JavaExpr("new com.google.template.soy.data.restricted.BooleanData(" + string5 + " == 0)", BooleanData.class, Integer.MAX_VALUE));
        hashMap.put(string + "__isLast", new JavaExpr("new com.google.template.soy.data.restricted.BooleanData(" + string5 + " == " + string4 + " - 1)", BooleanData.class, Integer.MAX_VALUE));
        hashMap.put(string + "__index", new JavaExpr("new com.google.template.soy.data.restricted.IntegerData(" + string5 + ")", IntegerData.class, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(foreachNonemptyNode);
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        String string;
        String string2;
        String string3;
        String string4 = forNode.getLocalVarName();
        String string5 = forNode.getId();
        TranslateToJavaExprVisitor translateToJavaExprVisitor = this.translateToJavaExprVisitorFactory.create(this.localVarTranslations);
        ArrayList arrayList = Lists.newArrayList(forNode.getRangeArgs());
        String string6 = arrayList.size() == 3 ? JavaCodeUtils.genIntegerValue((JavaExpr)translateToJavaExprVisitor.exec((Node)arrayList.remove(2))) : "1";
        String string7 = arrayList.size() == 2 ? JavaCodeUtils.genIntegerValue((JavaExpr)translateToJavaExprVisitor.exec((Node)arrayList.remove(0))) : "0";
        String string8 = JavaCodeUtils.genIntegerValue((JavaExpr)translateToJavaExprVisitor.exec((Node)arrayList.get(0)));
        if (INTEGER.matcher(string7).matches()) {
            string3 = string7;
        } else {
            string3 = string4 + "Init" + string5;
            this.javaCodeBuilder.appendLine("int ", string3, " = ", string7, ";");
        }
        if (INTEGER.matcher(string8).matches()) {
            string2 = string8;
        } else {
            string2 = string4 + "Limit" + string5;
            this.javaCodeBuilder.appendLine("int ", string2, " = ", string8, ";");
        }
        if (INTEGER.matcher(string6).matches()) {
            string = string6;
        } else {
            string = string4 + "Increment" + string5;
            this.javaCodeBuilder.appendLine("int ", string, " = ", string6, ";");
        }
        String string9 = string.equals("1") ? string4 + string5 + "++" : string4 + string5 + " += " + string;
        this.javaCodeBuilder.appendLine("for (int ", string4, string5, " = ", string3, "; ", string4, string5, " < ", string2, "; ", string9, ") {");
        this.javaCodeBuilder.increaseIndent();
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(string4, new JavaExpr("new com.google.template.soy.data.restricted.IntegerData(" + string4 + string5 + ")", IntegerData.class, Integer.MAX_VALUE));
        this.localVarTranslations.push(hashMap);
        this.visitChildren(forNode);
        this.localVarTranslations.pop();
        this.javaCodeBuilder.decreaseIndent();
        this.javaCodeBuilder.appendLine("}");
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        Object object;
        for (CallParamNode callParamNode : callNode.getChildren()) {
            if (!(callParamNode instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJavaExprsVisitor.exec(callParamNode)).booleanValue()) continue;
            this.visit(callParamNode);
        }
        if (this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.STRINGBUILDER) {
            object = this.genCallCodeUtils.genObjToPass(callNode, this.localVarTranslations);
            this.javaCodeBuilder.indent().append(callNode.getCalleeName().replace('.', '$'), "(", ((JavaExpr)object).getText(), ", ").appendOutputVarName().append(");\n");
        } else {
            object = this.genCallCodeUtils.genCallExpr(callNode, this.localVarTranslations);
            this.javaCodeBuilder.addToOutputVar((List<JavaExpr>)ImmutableList.of((Object)object));
        }
    }

    @Override
    protected void visitInternal(CallParamContentNode callParamContentNode) {
        if (((Boolean)this.isComputableAsJavaExprsVisitor.exec(callParamContentNode)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'param<n>' when not computable as Java expressions.");
        }
        this.localVarTranslations.push(Maps.newHashMap());
        this.javaCodeBuilder.pushOutputVar("param" + callParamContentNode.getId());
        this.visitChildren(callParamContentNode);
        this.javaCodeBuilder.popOutputVar();
        this.localVarTranslations.pop();
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
        if (!((Boolean)this.isComputableAsJavaExprsVisitor.exec(soyNode)).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        this.javaCodeBuilder.addToOutputVar(this.genJavaExprsVisitor.exec(soyNode));
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.localVarTranslations.push(Maps.newHashMap());
        this.visitChildren(parentSoyNode);
        this.localVarTranslations.pop();
    }
}

