/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.shared.internal.ImpureFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;

public class TranslateToJavaExprVisitor
extends AbstractExprNodeVisitor<JavaExpr> {
    private final Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;
    private Deque<JavaExpr> resultStack;

    @AssistedInject
    TranslateToJavaExprVisitor(Map<String, SoyJavaSrcFunction> map, @Assisted Deque<Map<String, JavaExpr>> deque) {
        this.soyJavaSrcFunctionsMap = map;
        this.localVarTranslations = deque;
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<JavaExpr>();
    }

    @Override
    protected JavaExpr getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(ExprRootNode<? extends ExprNode> exprRootNode) {
        this.visitChildren(exprRootNode);
    }

    @Override
    protected void visitInternal(NullNode nullNode) {
        this.resultStack.push(new JavaExpr("com.google.template.soy.data.restricted.NullData.INSTANCE", NullData.class, Integer.MAX_VALUE));
    }

    @Override
    protected void visitInternal(BooleanNode booleanNode) {
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData(booleanNode.toSourceString()));
    }

    @Override
    protected void visitInternal(IntegerNode integerNode) {
        this.pushIntegerResult(JavaCodeUtils.genNewIntegerData(integerNode.toSourceString()));
    }

    @Override
    protected void visitInternal(FloatNode floatNode) {
        this.pushFloatResult(JavaCodeUtils.genNewFloatData(floatNode.toSourceString()));
    }

    @Override
    protected void visitInternal(StringNode stringNode) {
        this.pushStringResult(JavaCodeUtils.genNewStringData('\"' + CharEscapers.javaStringEscaper().escape(stringNode.getValue()) + '\"'));
    }

    @Override
    protected void visitInternal(DataRefNode dataRefNode) {
        String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
        JavaExpr javaExpr = this.getLocalVarTranslation(string);
        if (javaExpr != null) {
            if (dataRefNode.numChildren() == 1) {
                this.resultStack.push(javaExpr);
            } else {
                this.pushUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", JavaCodeUtils.genMaybeCast(javaExpr, CollectionData.class), this.buildKeyStringExprText(dataRefNode, 1)));
            }
        } else {
            this.pushUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", "data", this.buildKeyStringExprText(dataRefNode, 0)));
        }
    }

    private String buildKeyStringExprText(DataRefNode dataRefNode, int n) {
        ArrayList arrayList = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < dataRefNode.numChildren(); ++i) {
            ExprNode exprNode = dataRefNode.getChild(i);
            if (i != n) {
                stringBuilder.append(".");
            }
            if (exprNode instanceof DataRefKeyNode) {
                stringBuilder.append(CharEscapers.javaStringEscaper().escape(((DataRefKeyNode)exprNode).getKey()));
                continue;
            }
            if (exprNode instanceof DataRefIndexNode) {
                stringBuilder.append(Integer.toString(((DataRefIndexNode)exprNode).getIndex()));
                continue;
            }
            this.visit(exprNode);
            arrayList.add("\"" + stringBuilder.toString() + "\"");
            arrayList.add(JavaCodeUtils.genMaybeProtect(this.resultStack.pop(), Integer.MAX_VALUE) + ".toString()");
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add("\"" + stringBuilder.toString() + "\"");
        }
        return Joiner.on((String)" + ").join((Iterable)arrayList);
    }

    @Override
    protected void visitInternal(GlobalNode globalNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void visitInternal(OperatorNodes.NegativeOpNode negativeOpNode) {
        this.visitChildren(negativeOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        String string = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genIntegerValue(javaExpr)));
        String string2 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genFloatValue(javaExpr)));
        if (JavaCodeUtils.isAlwaysInteger(javaExpr)) {
            this.pushIntegerResult(string);
        } else if (JavaCodeUtils.isAlwaysFloat(javaExpr)) {
            this.pushFloatResult(string2);
        } else {
            this.pushNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$negative", javaExpr.getText()));
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.NotOpNode notOpNode) {
        this.visitChildren(notOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genUnaryOp("!", JavaCodeUtils.genCoerceBoolean(javaExpr))));
    }

    @Override
    protected void visitInternal(OperatorNodes.TimesOpNode timesOpNode) {
        this.visitNumberToNumberBinaryOpHelper(timesOpNode, "*", "$$times");
    }

    @Override
    protected void visitInternal(OperatorNodes.DivideByOpNode divideByOpNode) {
        this.visitChildren(divideByOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        this.pushFloatResult(JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("/", JavaCodeUtils.genNumberValue(javaExpr2), JavaCodeUtils.genNumberValue(javaExpr))));
    }

    @Override
    protected void visitInternal(OperatorNodes.ModOpNode modOpNode) {
        this.visitChildren(modOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        this.pushIntegerResult(JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("%", JavaCodeUtils.genIntegerValue(javaExpr2), JavaCodeUtils.genIntegerValue(javaExpr))));
    }

    @Override
    protected void visitInternal(OperatorNodes.PlusOpNode plusOpNode) {
        this.visitChildren(plusOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        String string = JavaCodeUtils.genNewStringData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genCoerceString(javaExpr2), JavaCodeUtils.genCoerceString(javaExpr)));
        String string2 = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genIntegerValue(javaExpr2), JavaCodeUtils.genIntegerValue(javaExpr)));
        String string3 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genNumberValue(javaExpr2), JavaCodeUtils.genNumberValue(javaExpr)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr2, javaExpr)) {
            this.pushIntegerResult(string2);
        } else if (JavaCodeUtils.isAlwaysAtLeastOneString(javaExpr2, javaExpr)) {
            this.pushStringResult(string);
        } else if (JavaCodeUtils.isAlwaysTwoFloatsOrOneFloatOneInteger(javaExpr2, javaExpr)) {
            this.pushFloatResult(string3);
        } else {
            this.pushNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$plus", javaExpr2.getText(), javaExpr.getText()));
        }
    }

    @Override
    protected void visitInternal(OperatorNodes.MinusOpNode minusOpNode) {
        this.visitNumberToNumberBinaryOpHelper(minusOpNode, "-", "$$minus");
    }

    @Override
    protected void visitInternal(OperatorNodes.LessThanOpNode lessThanOpNode) {
        this.visitNumberToBooleanBinaryOpHelper(lessThanOpNode, "<", "$$lessThan");
    }

    @Override
    protected void visitInternal(OperatorNodes.GreaterThanOpNode greaterThanOpNode) {
        this.visitNumberToBooleanBinaryOpHelper(greaterThanOpNode, ">", "$$greaterThan");
    }

    @Override
    protected void visitInternal(OperatorNodes.LessThanOrEqualOpNode lessThanOrEqualOpNode) {
        this.visitNumberToBooleanBinaryOpHelper(lessThanOrEqualOpNode, "<=", "$$lessThanOrEqual");
    }

    @Override
    protected void visitInternal(OperatorNodes.GreaterThanOrEqualOpNode greaterThanOrEqualOpNode) {
        this.visitNumberToBooleanBinaryOpHelper(greaterThanOrEqualOpNode, ">=", "$$greaterThanOrEqual");
    }

    @Override
    protected void visitInternal(OperatorNodes.EqualOpNode equalOpNode) {
        this.visitChildren(equalOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genMaybeProtect(javaExpr2, Integer.MAX_VALUE) + ".equals(" + javaExpr.getText() + ")"));
    }

    @Override
    protected void visitInternal(OperatorNodes.NotEqualOpNode notEqualOpNode) {
        this.visitChildren(notEqualOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData("! " + JavaCodeUtils.genMaybeProtect(javaExpr2, Integer.MAX_VALUE) + ".equals(" + javaExpr.getText() + ")"));
    }

    @Override
    protected void visitInternal(OperatorNodes.AndOpNode andOpNode) {
        this.visitBooleanToBooleanBinaryOpHelper(andOpNode, "&&");
    }

    @Override
    protected void visitInternal(OperatorNodes.OrOpNode orOpNode) {
        this.visitBooleanToBooleanBinaryOpHelper(orOpNode, "||");
    }

    @Override
    protected void visitInternal(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        this.visitChildren(conditionalOpNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        JavaExpr javaExpr3 = this.resultStack.pop();
        Class<?> clazz = javaExpr2.getType();
        Class<?> clazz2 = javaExpr.getType();
        Class<?> clazz3 = null;
        for (Class<?> clazz4 = clazz; clazz4 != null; clazz4 = clazz4.getSuperclass()) {
            if (!clazz4.isAssignableFrom(clazz2)) continue;
            clazz3 = clazz4;
            break;
        }
        if (clazz3 == null) {
            throw new AssertionError();
        }
        this.resultStack.push(new JavaExpr(JavaCodeUtils.genCoerceBoolean(javaExpr3) + " ? " + JavaCodeUtils.genMaybeProtect(javaExpr2, Operator.CONDITIONAL.getPrecedence() + 1) + " : " + JavaCodeUtils.genMaybeProtect(javaExpr, Operator.CONDITIONAL.getPrecedence() + 1), clazz3, Operator.CONDITIONAL.getPrecedence()));
    }

    @Override
    protected void visitInternal(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        ImpureFunction impureFunction = ImpureFunction.forFunctionName(string);
        if (impureFunction != null) {
            if (n != impureFunction.getNumArgs()) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (impureFunction) {
                case IS_FIRST: {
                    this.visitIsFirstFunction(functionNode);
                    return;
                }
                case IS_LAST: {
                    this.visitIsLastFunction(functionNode);
                    return;
                }
                case INDEX: {
                    this.visitIndexFunction(functionNode);
                    return;
                }
                case HAS_DATA: {
                    this.visitHasDataFunction();
                    return;
                }
            }
            throw new AssertionError();
        }
        SoyJavaSrcFunction soyJavaSrcFunction = this.soyJavaSrcFunctionsMap.get(string);
        if (soyJavaSrcFunction != null) {
            if (!soyJavaSrcFunction.getValidArgsSizes().contains(n)) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            ArrayList arrayList = Lists.newArrayList();
            for (ExprNode exprNode : functionNode.getChildren()) {
                this.visit(exprNode);
                arrayList.add(this.resultStack.pop());
            }
            try {
                this.resultStack.push(soyJavaSrcFunction.computeForJavaSrc(arrayList));
            }
            catch (Exception exception) {
                throw new SoySyntaxException("Error in function call \"" + functionNode.toSourceString() + "\": " + exception.getMessage(), exception);
            }
            return;
        }
        throw new SoySyntaxException("Failed to find SoyJavaSrcFunction with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
    }

    private void visitIsFirstFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__isFirst"));
    }

    private void visitIsLastFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__isLast"));
    }

    private void visitIndexFunction(FunctionNode functionNode) {
        String string = ((DataRefKeyNode)((DataRefNode)functionNode.getChild(0)).getChild(0)).getKey();
        this.resultStack.push(this.getLocalVarTranslation(string + "__index"));
    }

    private void visitHasDataFunction() {
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData("data != null"));
    }

    private void pushBooleanResult(String string) {
        this.resultStack.push(new JavaExpr(string, BooleanData.class, Integer.MAX_VALUE));
    }

    private void pushIntegerResult(String string) {
        this.resultStack.push(new JavaExpr(string, IntegerData.class, Integer.MAX_VALUE));
    }

    private void pushFloatResult(String string) {
        this.resultStack.push(new JavaExpr(string, FloatData.class, Integer.MAX_VALUE));
    }

    private void pushNumberResult(String string) {
        this.resultStack.push(new JavaExpr(string, NumberData.class, Integer.MAX_VALUE));
    }

    private void pushStringResult(String string) {
        this.resultStack.push(new JavaExpr(string, StringData.class, Integer.MAX_VALUE));
    }

    private void pushUnknownResult(String string) {
        this.resultStack.push(new JavaExpr(string, SoyData.class, Integer.MAX_VALUE));
    }

    private void visitBooleanToBooleanBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string) {
        this.visitChildren(operatorNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        this.pushBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genCoerceBoolean(javaExpr2), JavaCodeUtils.genCoerceBoolean(javaExpr))));
    }

    private void visitNumberToNumberBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string, String string2) {
        this.visitChildren(operatorNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        String string3 = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genIntegerValue(javaExpr2), JavaCodeUtils.genIntegerValue(javaExpr)));
        String string4 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genNumberValue(javaExpr2), JavaCodeUtils.genNumberValue(javaExpr)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr2, javaExpr)) {
            this.pushIntegerResult(string3);
        } else if (JavaCodeUtils.isAlwaysAtLeastOneFloat(javaExpr2, javaExpr)) {
            this.pushFloatResult(string4);
        } else {
            this.pushNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + string2, JavaCodeUtils.genMaybeCast(javaExpr2, NumberData.class), JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class)));
        }
    }

    private void visitNumberToBooleanBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string, String string2) {
        this.visitChildren(operatorNode);
        JavaExpr javaExpr = this.resultStack.pop();
        JavaExpr javaExpr2 = this.resultStack.pop();
        String string3 = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genIntegerValue(javaExpr2), JavaCodeUtils.genIntegerValue(javaExpr)));
        String string4 = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genNumberValue(javaExpr2), JavaCodeUtils.genNumberValue(javaExpr)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr2, javaExpr)) {
            this.pushBooleanResult(string3);
        } else if (JavaCodeUtils.isAlwaysAtLeastOneFloat(javaExpr2, javaExpr)) {
            this.pushBooleanResult(string4);
        } else {
            this.pushBooleanResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + string2, JavaCodeUtils.genMaybeCast(javaExpr2, NumberData.class), JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class)));
        }
    }

    private JavaExpr getLocalVarTranslation(String string) {
        for (Map<String, JavaExpr> map : this.localVarTranslations) {
            JavaExpr javaExpr = map.get(string);
            if (javaExpr == null) continue;
            return javaExpr;
        }
        return null;
    }

    public static interface TranslateToJavaExprVisitorFactory {
        public TranslateToJavaExprVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

