/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc;

import com.google.common.base.Preconditions;

public class SoyJsSrcOptions
implements Cloneable {
    private boolean shouldAllowDeprecatedSyntax = false;
    private CodeStyle codeStyle = CodeStyle.STRINGBUILDER;
    private boolean shouldGenerateJsdoc = false;
    private boolean shouldProvideRequireSoyNamespaces = false;
    private boolean shouldProvideRequireJsFunctions = false;
    private boolean shouldDeclareTopLevelNamespaces = true;
    private boolean shouldGenerateGoogMsgDefs = false;
    private boolean googMsgsAreExternal = false;
    private int bidiGlobalDir = 0;

    public void setShouldAllowDeprecatedSyntax(boolean bl) {
        this.shouldAllowDeprecatedSyntax = bl;
    }

    public boolean shouldAllowDeprecatedSyntax() {
        return this.shouldAllowDeprecatedSyntax;
    }

    public void setCodeStyle(CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
    }

    public CodeStyle getCodeStyle() {
        return this.codeStyle;
    }

    public void setShouldGenerateJsdoc(boolean bl) {
        this.shouldGenerateJsdoc = bl;
    }

    public boolean shouldGenerateJsdoc() {
        return this.shouldGenerateJsdoc;
    }

    public void setShouldProvideRequireSoyNamespaces(boolean bl) {
        this.shouldProvideRequireSoyNamespaces = bl;
        Preconditions.checkState((!this.shouldProvideRequireSoyNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Must not enable both shouldProvideRequireSoyNamespaces and shouldProvideRequireJsFunctions.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireSoyNamespaces ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireSoyNamespaces is enabled.");
    }

    public boolean shouldProvideRequireSoyNamespaces() {
        return this.shouldProvideRequireSoyNamespaces;
    }

    public void setShouldProvideRequireJsFunctions(boolean bl) {
        this.shouldProvideRequireJsFunctions = bl;
        Preconditions.checkState((!this.shouldProvideRequireSoyNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Must not enable both shouldProvideRequireSoyNamespaces and shouldProvideRequireJsFunctions.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireJsFunctions is enabled.");
    }

    public boolean shouldProvideRequireJsFunctions() {
        return this.shouldProvideRequireJsFunctions;
    }

    public void setShouldDeclareTopLevelNamespaces(boolean bl) {
        this.shouldDeclareTopLevelNamespaces = bl;
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireSoyNamespaces ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireSoyNamespaces is enabled.");
        Preconditions.checkState((this.shouldDeclareTopLevelNamespaces || !this.shouldProvideRequireJsFunctions ? 1 : 0) != 0, (Object)"Turning off shouldDeclareTopLevelNamespaces has no meaning when shouldProvideRequireJsFunctions is enabled.");
    }

    public boolean shouldDeclareTopLevelNamespaces() {
        return this.shouldDeclareTopLevelNamespaces;
    }

    public void setShouldGenerateGoogMsgDefs(boolean bl) {
        this.shouldGenerateGoogMsgDefs = bl;
    }

    public boolean shouldGenerateGoogMsgDefs() {
        return this.shouldGenerateGoogMsgDefs;
    }

    public void setGoogMsgsAreExternal(boolean bl) {
        this.googMsgsAreExternal = bl;
    }

    public boolean googMsgsAreExternal() {
        return this.googMsgsAreExternal;
    }

    public void setBidiGlobalDir(int n) {
        Preconditions.checkArgument((n == 1 || n == -1 || n == 0 ? 1 : 0) != 0, (Object)"Bidi global directionality must be 1 for LTR, -1 for RTL, or 0 to infer this from the locale string in the message bundle.");
        this.bidiGlobalDir = n;
        Preconditions.checkState((!this.shouldGenerateGoogMsgDefs || n != 0 ? 1 : 0) != 0, (Object)"If shouldGenerateGoogMsgDefs is true, then bidiGlobalDir must be set to 1 or -1.");
    }

    public int getBidiGlobalDir() {
        return this.bidiGlobalDir;
    }

    public SoyJsSrcOptions clone() {
        try {
            return (SoyJsSrcOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Cloneable interface removed from SoyJsSrcOptions");
        }
    }

    public static enum CodeStyle {
        STRINGBUILDER,
        CONCAT;

    }
}

