/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayDeque;
import java.util.Deque;

class CanInitOutputVarVisitor
extends AbstractSoyNodeVisitor<Boolean> {
    private final SoyJsSrcOptions jsSrcOptions;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private Deque<Boolean> resultStack;

    @Inject
    CanInitOutputVarVisitor(SoyJsSrcOptions soyJsSrcOptions, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor) {
        this.jsSrcOptions = soyJsSrcOptions;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
    }

    @Override
    protected void setup() {
        this.resultStack = new ArrayDeque<Boolean>();
    }

    @Override
    protected Boolean getResult() {
        return this.resultStack.peek();
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        this.resultStack.push(this.jsSrcOptions.getCodeStyle() == SoyJsSrcOptions.CodeStyle.CONCAT);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
        this.resultStack.push((Boolean)this.isComputableAsJsExprsVisitor.exec(soyNode));
    }
}

