/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Sets;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Set;
import java.util.SortedSet;

public class FindCalleesNotInFileVisitor
extends AbstractSoyNodeVisitor<Set<String>> {
    private Set<String> templatesInFile;
    private SortedSet<String> calleesNotInFile;

    @Override
    protected SortedSet<String> getResult() {
        return this.calleesNotInFile;
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.templatesInFile = Sets.newHashSet();
        for (TemplateNode templateNode : soyFileNode.getChildren()) {
            this.templatesInFile.add(templateNode.getTemplateName());
        }
        this.calleesNotInFile = Sets.newTreeSet();
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        String string = callNode.getCalleeName();
        if (!this.templatesInFile.contains(string)) {
            this.calleesNotInFile.add(string);
        }
        this.visitChildren(callNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

