/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

class JsCodeBuilder {
    private static final String SPACES = "                    ";
    private final StringBuilder code;
    private final SoyJsSrcOptions.CodeStyle codeStyle;
    private String indent;
    private Deque<Pair<String, Boolean>> outputVars;
    private String currOutputVarName;
    private boolean currOutputVarIsInited;

    public JsCodeBuilder(SoyJsSrcOptions.CodeStyle codeStyle) {
        this.codeStyle = codeStyle;
        this.code = new StringBuilder();
        this.indent = "";
        this.outputVars = new ArrayDeque<Pair<String, Boolean>>();
        this.currOutputVarName = null;
        this.currOutputVarIsInited = false;
    }

    public void increaseIndent() throws SoySyntaxException {
        int n = this.indent.length() + 2;
        if (n > 20) {
            throw new SoySyntaxException("Indent is more than 20 spaces!");
        }
        this.indent = SPACES.substring(0, n);
    }

    public void decreaseIndent() throws SoySyntaxException {
        int n = this.indent.length() - 2;
        if (n < 0) {
            throw new SoySyntaxException("Indent is less than 0 spaces!");
        }
        this.indent = SPACES.substring(0, n);
    }

    public void pushOutputVar(String string) {
        this.outputVars.push(Pair.of(string, false));
        this.currOutputVarName = string;
        this.currOutputVarIsInited = false;
    }

    public void popOutputVar() {
        this.outputVars.pop();
        Pair<String, Boolean> pair = this.outputVars.peek();
        if (pair != null) {
            this.currOutputVarName = pair.getFirst();
            this.currOutputVarIsInited = pair.getSecond();
        } else {
            this.currOutputVarName = null;
            this.currOutputVarIsInited = false;
        }
    }

    public void setOutputVarInited() {
        this.outputVars.pop();
        this.outputVars.push(Pair.of(this.currOutputVarName, true));
        this.currOutputVarIsInited = true;
    }

    public JsCodeBuilder indent() {
        this.code.append(this.indent);
        return this;
    }

    public JsCodeBuilder append(String ... stringArray) {
        for (String string : stringArray) {
            this.code.append(string);
        }
        return this;
    }

    public JsCodeBuilder appendLine(String ... stringArray) {
        this.indent();
        this.append(stringArray);
        this.code.append("\n");
        return this;
    }

    public JsCodeBuilder appendOutputVarName() {
        this.code.append(this.currOutputVarName);
        return this;
    }

    public void initOutputVarIfNecessary() {
        if (this.currOutputVarIsInited) {
            return;
        }
        if (this.codeStyle == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            this.appendLine("var ", this.currOutputVarName, " = new soy.StringBuilder();");
        } else {
            this.appendLine("var ", this.currOutputVarName, " = '';");
        }
        this.setOutputVarInited();
    }

    public void addToOutputVar(List<JsExpr> list) {
        if (this.codeStyle == SoyJsSrcOptions.CodeStyle.STRINGBUILDER) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (JsExpr jsExpr : list) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(jsExpr.getText());
            }
            if (this.currOutputVarIsInited) {
                this.appendLine(this.currOutputVarName, ".append(", stringBuilder.toString(), ");");
            } else {
                this.appendLine("var ", this.currOutputVarName, " = new soy.StringBuilder(", stringBuilder.toString(), ");");
                this.setOutputVarInited();
            }
        } else {
            JsExpr jsExpr = JsExprUtils.concatJsExprs(list);
            if (this.currOutputVarIsInited) {
                this.appendLine(this.currOutputVarName, " += ", jsExpr.getText(), ";");
            } else {
                this.appendLine("var ", this.currOutputVarName, " = ", jsExpr.getText(), ";");
                this.setOutputVarInited();
            }
        }
    }

    public String getCode() {
        return this.code.toString();
    }
}

