/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.template.soy.base.BaseUtils;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.MoveGoogMsgNodesEarlierVisitor;
import com.google.template.soy.jssrc.internal.OptimizeBidiCodeGenVisitor;
import com.google.template.soy.jssrc.internal.ReplaceMsgsWithGoogMsgsVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.CheckSoyDocVisitor;
import com.google.template.soy.sharedpasses.RemoveHtmlCommentsVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;

public class JsSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final Provider<ReplaceMsgsWithGoogMsgsVisitor> replaceMsgsWithGoogMsgsVisitorProvider;
    private final Provider<OptimizeBidiCodeGenVisitor> optimizeBidiCodeGenVisitorProvider;
    private final Provider<GenJsCodeVisitor> genJsCodeVisitorProvider;

    @Inject
    JsSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope guiceSimpleScope, Provider<ReplaceMsgsWithGoogMsgsVisitor> provider, Provider<OptimizeBidiCodeGenVisitor> provider2, Provider<GenJsCodeVisitor> provider3) {
        this.apiCallScope = guiceSimpleScope;
        this.replaceMsgsWithGoogMsgsVisitorProvider = provider;
        this.optimizeBidiCodeGenVisitorProvider = provider2;
        this.genJsCodeVisitorProvider = provider3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> genJsSrc(SoyFileSetNode soyFileSetNode, SoyJsSrcOptions soyJsSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        if (soyJsSrcOptions.shouldAllowDeprecatedSyntax()) {
            new RemoveHtmlCommentsVisitor().exec(soyFileSetNode);
            new CheckSoyDocVisitor(false).exec(soyFileSetNode);
        } else {
            new AssertSyntaxVersionV2Visitor().exec(soyFileSetNode);
            new CheckSoyDocVisitor(true).exec(soyFileSetNode);
        }
        this.apiCallScope.enter();
        try {
            this.apiCallScope.seed(SoyJsSrcOptions.class, soyJsSrcOptions);
            ApiCallScopeUtils.seedSharedParams(this.apiCallScope, soyMsgBundle, soyJsSrcOptions.getBidiGlobalDir());
            if (soyJsSrcOptions.shouldGenerateGoogMsgDefs()) {
                ((ReplaceMsgsWithGoogMsgsVisitor)this.replaceMsgsWithGoogMsgsVisitorProvider.get()).exec(soyFileSetNode);
                new MoveGoogMsgNodesEarlierVisitor().exec(soyFileSetNode);
                Preconditions.checkState((soyJsSrcOptions.getBidiGlobalDir() != 0 ? 1 : 0) != 0, (Object)"If enabling shouldGenerateGoogMsgDefs, must also set bidiGlobalDir.");
            } else {
                new InsertMsgsVisitor(soyMsgBundle).exec(soyFileSetNode);
            }
            ((OptimizeBidiCodeGenVisitor)this.optimizeBidiCodeGenVisitorProvider.get()).exec(soyFileSetNode);
            List list = (List)((GenJsCodeVisitor)this.genJsCodeVisitorProvider.get()).exec(soyFileSetNode);
            return list;
        }
        finally {
            this.apiCallScope.exit();
        }
    }

    public void genJsFiles(SoyFileSetNode soyFileSetNode, SoyJsSrcOptions soyJsSrcOptions, @Nullable String string, @Nullable SoyMsgBundle soyMsgBundle, String string2, String string3) throws SoySyntaxException, IOException {
        List<String> list = this.genJsSrc(soyFileSetNode, soyJsSrcOptions, soyMsgBundle);
        int n = soyFileSetNode.numChildren();
        if (n != list.size()) {
            throw new AssertionError();
        }
        for (int i = 0; i < n; ++i) {
            String string4 = ((SoyFileNode)soyFileSetNode.getChild(i)).getFilePath();
            String string5 = JsSrcUtils.buildFilePath(string2, string, string4, string3);
            BaseUtils.ensureDirsExistInPath(string5);
            Files.write((CharSequence)list.get(i), (File)new File(string5), (Charset)Charsets.UTF_8);
        }
    }
}

