/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.sharedpasses.BuildNearestDependeeMapVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.jssrc.GoogMsgNode;
import java.util.List;
import java.util.Map;

class MoveGoogMsgNodesEarlierVisitor
extends AbstractSoyNodeVisitor<Void> {
    private List<GoogMsgNode> googMsgNodes;

    MoveGoogMsgNodesEarlierVisitor() {
    }

    @Override
    protected void setup() {
        this.googMsgNodes = Lists.newArrayList();
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
        Map map = (Map)new BuildNearestDependeeMapVisitor().exec(soyFileSetNode);
        for (GoogMsgNode googMsgNode : this.googMsgNodes) {
            this.moveGoogMsgNodeEarlierHelper(googMsgNode, (SoyNode)map.get(googMsgNode));
        }
    }

    @Override
    protected void visitInternal(GoogMsgNode googMsgNode) {
        this.googMsgNodes.add(googMsgNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }

    private void moveGoogMsgNodeEarlierHelper(GoogMsgNode googMsgNode, SoyNode soyNode) {
        int n;
        SoyNode.ParentSoyNode parentSoyNode;
        if (soyNode instanceof SoyNode.LocalVarInlineNode) {
            parentSoyNode = soyNode.getParent();
            n = parentSoyNode.getChildIndex((SoyNode)soyNode) + 1;
        } else if (soyNode instanceof SoyNode.ParentSoyNode) {
            parentSoyNode = (SoyNode.ParentSoyNode)soyNode;
            n = 0;
        } else {
            throw new AssertionError();
        }
        List list = parentSoyNode.getChildren();
        while (n < list.size() && list.get(n) instanceof GoogMsgNode) {
            if (googMsgNode == list.get(n)) {
                return;
            }
            ++n;
        }
        googMsgNode.getParent().removeChild(googMsgNode);
        parentSoyNode.addChild(n, googMsgNode);
    }
}

