/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.inject.Inject;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.coredirectives.CoreDirectiveUtils;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.sharedpasses.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;

class OptimizeBidiCodeGenVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final String BIDI_MARK_FN_NAME = "bidiMark";
    private static final String BIDI_START_EDGE_FN_NAME = "bidiStartEdge";
    private static final String BIDI_END_EDGE_FN_NAME = "bidiEndEdge";
    private final Map<String, SoyJsSrcFunction> soyJsSrcFunctionsMap;
    private int bidiGlobalDir;
    private IdGenerator nodeIdGen;
    boolean madeReplacement;

    @Inject
    OptimizeBidiCodeGenVisitor(Map<String, SoyJsSrcFunction> map, @ApiCallScopeBindingAnnotations.BidiGlobalDir int n) {
        this.soyJsSrcFunctionsMap = map;
        this.bidiGlobalDir = n;
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        if (!(this.soyJsSrcFunctionsMap.containsKey(BIDI_MARK_FN_NAME) && this.soyJsSrcFunctionsMap.containsKey(BIDI_START_EDGE_FN_NAME) && this.soyJsSrcFunctionsMap.containsKey(BIDI_END_EDGE_FN_NAME))) {
            return;
        }
        this.nodeIdGen = soyFileSetNode.getNodeIdGen();
        this.madeReplacement = false;
        this.visitChildren(soyFileSetNode);
        if (this.madeReplacement) {
            new CombineConsecutiveRawTextNodesVisitor().exec(soyFileSetNode);
        }
    }

    @Override
    protected void visitInternal(PrintNode printNode) {
        String string;
        if (printNode.getSyntaxVersion() != SoyNode.SyntaxVersion.V2) {
            return;
        }
        ParentNode parentNode = printNode.getParent();
        if (parentNode instanceof MsgNode) {
            return;
        }
        Node node = printNode.getExpr().getChild(0);
        if (!(node instanceof FunctionNode)) {
            return;
        }
        String string2 = ((FunctionNode)node).getFunctionName();
        if (string2.equals(BIDI_MARK_FN_NAME)) {
            string = this.bidiGlobalDir < 0 ? "\\u200F" : "\\u200E";
        } else if (string2.equals(BIDI_START_EDGE_FN_NAME)) {
            string = this.bidiGlobalDir < 0 ? "right" : "left";
        } else if (string2.equals(BIDI_END_EDGE_FN_NAME)) {
            string = this.bidiGlobalDir < 0 ? "left" : "right";
        } else {
            return;
        }
        for (PrintDirectiveNode printDirectiveNode : printNode.getChildren()) {
            if (CoreDirectiveUtils.isCoreDirective(printDirectiveNode)) continue;
            return;
        }
        parentNode.setChild(parentNode.getChildIndex(printNode), new RawTextNode(this.nodeIdGen.genStringId(), string));
        this.madeReplacement = true;
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

