/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.restricted.SoyMsgIdComputer;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public class MsgUtils {
    private MsgUtils() {
    }

    public static List<SoyMsgPart> buildMsgParts(MsgNode msgNode) {
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode soyNode : msgNode.getChildren()) {
            String string;
            if (soyNode instanceof RawTextNode) {
                string = ((RawTextNode)soyNode).getRawText();
                arrayList.add(new SoyMsgRawTextPart(string));
                continue;
            }
            if (!(soyNode instanceof SoyNode.MsgPlaceholderNode)) continue;
            string = msgNode.getPlaceholderName((SoyNode.MsgPlaceholderNode)soyNode);
            arrayList.add(new SoyMsgPlaceholderPart(string));
        }
        return arrayList;
    }

    public static long computeMsgId(MsgNode msgNode) {
        return SoyMsgIdComputer.computeMsgId(MsgUtils.buildMsgParts(msgNode), msgNode.getMeaning(), msgNode.getContentType());
    }

    public static Pair<List<SoyMsgPart>, Long> buildMsgPartsAndComputeMsgId(MsgNode msgNode) {
        List<SoyMsgPart> list = MsgUtils.buildMsgParts(msgNode);
        long l = SoyMsgIdComputer.computeMsgId(list, msgNode.getMeaning(), msgNode.getContentType());
        return Pair.of(list, l);
    }
}

