/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.SoyMsg;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class SoyMsgBundleImpl
implements SoyMsgBundle {
    private final String localeString;
    private final Map<Long, SoyMsg> msgMap;

    public SoyMsgBundleImpl(@Nullable String string, List<SoyMsg> list) {
        this.localeString = string;
        TreeMap treeMap = Maps.newTreeMap();
        for (SoyMsg soyMsg : list) {
            Preconditions.checkArgument((boolean)Objects.equal((Object)soyMsg.getLocaleString(), (Object)string));
            long l = soyMsg.getId();
            if (!treeMap.containsKey(l)) {
                treeMap.put(l, soyMsg);
                continue;
            }
            SoyMsg soyMsg2 = (SoyMsg)treeMap.get(l);
            for (String string2 : soyMsg.getSourcePaths()) {
                soyMsg2.addSourcePath(string2);
            }
        }
        this.msgMap = ImmutableMap.copyOf((Map)treeMap);
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    public SoyMsg getMsg(long l) {
        return this.msgMap.get(l);
    }

    @Override
    public int getNumMsgs() {
        return this.msgMap.size();
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return this.msgMap.values().iterator();
    }
}

