/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import java.util.List;
import javax.annotation.Nullable;

public class SoyMsgIdComputer {
    private SoyMsgIdComputer() {
    }

    public static long computeMsgId(List<SoyMsgPart> list, @Nullable String string, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (SoyMsgPart soyMsgPart : list) {
            if (soyMsgPart instanceof SoyMsgRawTextPart) {
                stringBuilder.append(((SoyMsgRawTextPart)soyMsgPart).getRawText());
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                stringBuilder.append(((SoyMsgPlaceholderPart)soyMsgPart).getPlaceholderName());
                continue;
            }
            throw new AssertionError();
        }
        long l = SoyMsgIdComputer.fingerprint(stringBuilder.toString());
        if (string != null) {
            l = (l << 1) + (long)(l < 0L ? 1 : 0) + SoyMsgIdComputer.fingerprint(string);
        }
        if (string2 != null && !string2.equals("text/html")) {
            l = (l << 1) + (long)(l < 0L ? 1 : 0) + SoyMsgIdComputer.fingerprint(string2);
        }
        return l & Long.MAX_VALUE;
    }

    @VisibleForTesting
    static long fingerprint(String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        int n = SoyMsgIdComputer.hash32(byArray, 0, byArray.length, 0);
        int n2 = SoyMsgIdComputer.hash32(byArray, 0, byArray.length, 102072);
        if (n == 0 && (n2 == 0 || n2 == 1)) {
            n ^= 0x130F9BEF;
            n2 ^= 0x94A0A928;
        }
        return (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    private static int hash32(byte[] byArray, int n, int n2, int n3) {
        int n4 = -1640531527;
        int n5 = -1640531527;
        int n6 = n;
        while (n6 + 12 <= n2) {
            n4 += (byArray[n6 + 0] & 0xFF) << 0 | (byArray[n6 + 1] & 0xFF) << 8 | (byArray[n6 + 2] & 0xFF) << 16 | (byArray[n6 + 3] & 0xFF) << 24;
            n4 -= (n5 += (byArray[n6 + 4] & 0xFF) << 0 | (byArray[n6 + 5] & 0xFF) << 8 | (byArray[n6 + 6] & 0xFF) << 16 | (byArray[n6 + 7] & 0xFF) << 24);
            n4 -= (n3 += (byArray[n6 + 8] & 0xFF) << 0 | (byArray[n6 + 9] & 0xFF) << 8 | (byArray[n6 + 10] & 0xFF) << 16 | (byArray[n6 + 11] & 0xFF) << 24);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 13);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 8);
            n4 -= n5;
            n4 -= (n3 ^= n5 >>> 13);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 12);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 16);
            n4 -= n5;
            n4 -= (n3 ^= n5 >>> 5);
            n5 -= n3;
            n5 -= (n4 ^= n3 >>> 3);
            n3 -= n4;
            n3 -= (n5 ^= n4 << 10);
            n3 ^= n5 >>> 15;
            n6 += 12;
        }
        n3 += n2 - n;
        switch (n2 - n6) {
            case 11: {
                n3 += (byArray[n6 + 10] & 0xFF) << 24;
            }
            case 10: {
                n3 += (byArray[n6 + 9] & 0xFF) << 16;
            }
            case 9: {
                n3 += (byArray[n6 + 8] & 0xFF) << 8;
            }
            case 8: {
                n5 += (byArray[n6 + 7] & 0xFF) << 24;
            }
            case 7: {
                n5 += (byArray[n6 + 6] & 0xFF) << 16;
            }
            case 6: {
                n5 += (byArray[n6 + 5] & 0xFF) << 8;
            }
            case 5: {
                n5 += byArray[n6 + 4] & 0xFF;
            }
            case 4: {
                n4 += (byArray[n6 + 3] & 0xFF) << 24;
            }
            case 3: {
                n4 += (byArray[n6 + 2] & 0xFF) << 16;
            }
            case 2: {
                n4 += (byArray[n6 + 1] & 0xFF) << 8;
            }
            case 1: {
                n4 += byArray[n6 + 0] & 0xFF;
            }
        }
        n4 -= n5;
        n4 -= n3;
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 13);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 8);
        n4 -= n5;
        n4 -= (n3 ^= n5 >>> 13);
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 12);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 16);
        n4 -= n5;
        n4 -= (n3 ^= n5 >>> 5);
        n5 -= n3;
        n5 -= (n4 ^= n3 >>> 3);
        n3 -= n4;
        n3 -= (n5 ^= n4 << 10);
        return n3 ^= n5 >>> 15;
    }
}

