/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;

public class SoyTemplateInfo {
    private final String name;
    private final String partialName;
    private final ImmutableMap<String, ParamRequisiteness> params;

    public SoyTemplateInfo(String string, ImmutableMap<String, ParamRequisiteness> immutableMap) {
        this.name = string;
        int n = string.lastIndexOf(46);
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        this.partialName = string.substring(n);
        this.params = immutableMap;
    }

    public String getName() {
        return this.name;
    }

    public String getPartialName() {
        return this.partialName;
    }

    public ImmutableMap<String, ParamRequisiteness> getParams() {
        return this.params;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

