/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;

public class CheckOverridesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private Map<String, TemplateNode> templateMap;

    @Override
    protected void setup() {
        this.templateMap = Maps.newHashMap();
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        this.visitChildren(soyFileSetNode);
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        String string = templateNode.getTemplateName();
        Preconditions.checkArgument((string.charAt(0) != '.' ? 1 : 0) != 0);
        if (this.templateMap.containsKey(string)) {
            TemplateNode templateNode2 = this.templateMap.get(string);
            if (!templateNode.isOverride()) {
                String string2 = templateNode2.getNearestAncestor(SoyFileNode.class).getFilePath();
                String string3 = templateNode.getNearestAncestor(SoyFileNode.class).getFilePath();
                if (string3.equals(string2)) {
                    throw new SoySyntaxException("Found two definitions for template name '" + string + "', both in the file " + string3 + ".");
                }
                throw new SoySyntaxException("Found two definitions for template name '" + string + "' in two different files " + string2 + " and " + string3 + ".");
            }
        } else {
            this.templateMap.put(string, templateNode);
        }
    }
}

