/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.soytree.AbstractParentSoyCommandNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import java.util.List;

public class HandleCssCommandVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final SoyGeneralOptions.CssHandlingScheme cssHandlingScheme;
    private List<CssNode> cssNodes;

    public HandleCssCommandVisitor(SoyGeneralOptions.CssHandlingScheme cssHandlingScheme) {
        this.cssHandlingScheme = cssHandlingScheme;
    }

    @Override
    protected void setup() {
        this.cssNodes = Lists.newArrayList();
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.BACKEND_SPECIFIC) {
            return;
        }
        this.visitChildren(soyFileSetNode);
        IdGenerator idGenerator = soyFileSetNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
        for (CssNode cssNode : this.cssNodes) {
            ParentNode parentNode;
            Node node;
            if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.LITERAL) {
                node = new RawTextNode(idGenerator.genStringId(), cssNode.getCommandText());
            } else if (this.cssHandlingScheme == SoyGeneralOptions.CssHandlingScheme.REFERENCE) {
                parentNode = new PrintNode(idGenerator.genStringId(), cssNode.getCommandText() + "|noAutoescape", cssNode.getCommandText());
                PrintDirectiveNode printDirectiveNode = new PrintDirectiveNode(idGenerator.genStringId(), "|noAutoescape", "");
                ((AbstractParentSoyCommandNode)parentNode).addChild(printDirectiveNode);
                Node node2 = ((PrintNode)parentNode).getExpr().getChild(0);
                if (!(node2 instanceof DataRefNode) && !(node2 instanceof GlobalNode)) {
                    throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("The css-handling scheme is 'reference', but tag " + cssNode.getTagString() + " does not contain a valid reference.", null, soyFileSetNode);
                }
                node = parentNode;
            } else {
                throw new AssertionError();
            }
            parentNode = cssNode.getParent();
            parentNode.setChild(parentNode.getChildIndex(cssNode), node);
        }
    }

    @Override
    protected void visitInternal(CssNode cssNode) {
        this.cssNodes.add(cssNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

