/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;

public class PrependNamespacesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private String currNamespace = null;

    @Override
    protected void setup() {
        this.currNamespace = null;
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.currNamespace = soyFileNode.getNamespace();
        this.visitChildren(soyFileNode);
        this.currNamespace = null;
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        if (this.currNamespace == null) {
            if (templateNode.getTemplateName().charAt(0) == '.') {
                throw new SoySyntaxException("No namespace found in file " + ((SoyFileNode)templateNode.getParent()).getFileName() + ".");
            }
            return;
        }
        String string = templateNode.getTemplateName();
        if (string.charAt(0) == '.') {
            templateNode.setTemplateName(this.currNamespace + string);
        }
        this.visitChildren(templateNode);
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        Preconditions.checkState((this.currNamespace != null ? 1 : 0) != 0);
        String string = callNode.getCalleeName();
        if (string.charAt(0) == '.') {
            callNode.setCalleeName(this.currNamespace + string);
        }
        this.visitChildren(callNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
    }
}

