/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.template.soy.shared.internal.ImpureFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BackendModuleUtils {
    private BackendModuleUtils() {
    }

    public static <T extends SoyFunction> Map<String, T> buildBackendSpecificSoyFunctionsMap(Class<T> clazz, Set<SoyFunction> set) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)set.size());
        for (SoyFunction soyFunction : set) {
            if (!clazz.isAssignableFrom(soyFunction.getClass())) continue;
            String string = soyFunction.getName();
            if (hashSet.contains(string) || ImpureFunction.forFunctionName(string) != null) {
                throw new IllegalStateException("Found two implementations of " + clazz.getSimpleName() + " with the same function name '" + string + "'.");
            }
            hashSet.add(string);
            builder.put((Object)string, clazz.cast(soyFunction));
        }
        return builder.build();
    }

    public static <T extends SoyPrintDirective> Map<String, T> buildBackendSpecificSoyDirectivesMap(Class<T> clazz, Set<SoyPrintDirective> set) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)set.size());
        for (SoyPrintDirective soyPrintDirective : set) {
            if (!clazz.isAssignableFrom(soyPrintDirective.getClass())) continue;
            String string = soyPrintDirective.getName();
            if (hashSet.contains(string)) {
                throw new IllegalStateException("Found two implementations of " + clazz.getSimpleName() + " with the same directive name '" + string + "'.");
            }
            hashSet.add(string);
            builder.put((Object)string, clazz.cast(soyPrintDirective));
        }
        return builder.build();
    }
}

