/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.sharedpasses.AssertSyntaxVersionV2Visitor;
import com.google.template.soy.sharedpasses.FindIndirectParamsVisitor;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoytreeUtils;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CheckSoyDocVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final boolean isTreeAllV2;
    private Map<String, TemplateNode> templateNameToNodeMap;
    private boolean currFileHasOptParams;
    private boolean usesFunctionHasData;
    private Set<String> dataKeys;
    private Deque<Set<String>> localVarFrames;
    private GetDataKeysInExprVisitor getDataKeysInExprVisitor;

    public CheckSoyDocVisitor(boolean bl) {
        this.isTreeAllV2 = bl;
    }

    @Override
    protected void setup() {
        this.currFileHasOptParams = false;
        this.usesFunctionHasData = false;
        this.dataKeys = null;
        this.localVarFrames = null;
        this.getDataKeysInExprVisitor = null;
    }

    @Override
    protected void visitInternal(SoyFileSetNode soyFileSetNode) {
        this.templateNameToNodeMap = Maps.newHashMap();
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            for (TemplateNode templateNode : soyFileNode.getChildren()) {
                this.templateNameToNodeMap.put(templateNode.getTemplateName(), templateNode);
            }
        }
        for (SoyFileNode soyFileNode : soyFileSetNode.getChildren()) {
            boolean bl;
            if (this.isTreeAllV2) {
                bl = true;
            } else {
                try {
                    new AssertSyntaxVersionV2Visitor().exec(soyFileNode);
                    bl = true;
                }
                catch (SoySyntaxException soySyntaxException) {
                    bl = false;
                }
            }
            if (!bl) continue;
            this.visit(soyFileNode);
        }
    }

    @Override
    protected void visitInternal(SoyFileNode soyFileNode) {
        this.currFileHasOptParams = false;
        block0: for (TemplateNode templateNode : soyFileNode.getChildren()) {
            for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                if (soyDocParam.isRequired) continue;
                this.currFileHasOptParams = true;
                break block0;
            }
        }
        this.visitChildren(soyFileNode);
    }

    @Override
    protected void visitInternal(TemplateNode templateNode) {
        this.usesFunctionHasData = false;
        this.dataKeys = Sets.newHashSet();
        this.localVarFrames = new ArrayDeque<Set<String>>();
        this.getDataKeysInExprVisitor = new GetDataKeysInExprVisitor(this.dataKeys, this.localVarFrames);
        this.localVarFrames.push(Sets.newHashSet());
        this.visitChildren(templateNode);
        this.localVarFrames.pop();
        FindIndirectParamsVisitor.IndirectParamsInfo indirectParamsInfo = (FindIndirectParamsVisitor.IndirectParamsInfo)new FindIndirectParamsVisitor(true, false, this.templateNameToNodeMap).exec(templateNode);
        ArrayList arrayList = Lists.newArrayList();
        for (TemplateNode.SoyDocParam object : templateNode.getSoyDocParams()) {
            if (this.dataKeys.contains(object.key)) {
                this.dataKeys.remove(object.key);
                continue;
            }
            if (indirectParamsInfo.paramKeyToCalleesMultimap.containsKey((Object)object.key) || indirectParamsInfo.mayHaveExternalIndirectParams) continue;
            arrayList.add(object.key);
        }
        ArrayList arrayList2 = Lists.newArrayList();
        if (this.dataKeys.size() > 0) {
            arrayList2.addAll(this.dataKeys);
            Collections.sort(arrayList2);
        }
        this.dataKeys = null;
        this.getDataKeysInExprVisitor = null;
        if (arrayList2.size() > 0) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found references to data keys that are not declared in SoyDoc: " + arrayList2, null, templateNode);
        }
        if (arrayList.size() > 0) {
            throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Found params declared in SoyDoc but not used in template: " + arrayList, null, templateNode);
        }
        if (this.currFileHasOptParams && this.usesFunctionHasData) {
            for (TemplateNode.SoyDocParam soyDocParam : templateNode.getSoyDocParams()) {
                if (!soyDocParam.isRequired) continue;
                throw SoytreeUtils.createSoySyntaxExceptionWithMetaInfo("Unnecessary usage of hasData() since template has at least one required parameter.", null, templateNode);
            }
        }
    }

    @Override
    protected void visitInternal(IfNode ifNode) {
        this.visitChildren(ifNode);
    }

    @Override
    protected void visitInternal(SwitchNode switchNode) {
        this.visitExprHolderHelper(switchNode);
        this.visitChildren(switchNode);
    }

    @Override
    protected void visitInternal(ForeachNode foreachNode) {
        this.visitExprHolderHelper(foreachNode);
        this.visitChildren(foreachNode);
    }

    @Override
    protected void visitInternal(ForeachNonemptyNode foreachNonemptyNode) {
        HashSet hashSet = Sets.newHashSet();
        hashSet.add(foreachNonemptyNode.getLocalVarName());
        this.localVarFrames.push(hashSet);
        this.visitChildren(foreachNonemptyNode);
        this.localVarFrames.pop();
    }

    @Override
    protected void visitInternal(ForNode forNode) {
        this.visitExprHolderHelper(forNode);
        HashSet hashSet = Sets.newHashSet();
        hashSet.add(forNode.getLocalVarName());
        this.localVarFrames.push(hashSet);
        this.visitChildren(forNode);
        this.localVarFrames.pop();
    }

    @Override
    protected void visitInternal(CallNode callNode) {
        if (!callNode.isPassingAllData()) {
            this.visitExprHolderHelper(callNode);
        }
        this.visitChildren(callNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.localVarFrames.push(Sets.newHashSet());
        this.visitChildren(parentSoyNode);
        this.localVarFrames.pop();
    }

    @Override
    protected void visitInternal(SoyNode.ExprHolderNode exprHolderNode) {
        this.visitExprHolderHelper(exprHolderNode);
    }

    @Override
    protected void visitInternal(SoyNode.ParentExprHolderNode<? extends SoyNode> parentExprHolderNode) {
        this.visitExprHolderHelper(parentExprHolderNode);
        this.localVarFrames.push(Sets.newHashSet());
        this.visitChildren(parentExprHolderNode);
        this.localVarFrames.pop();
    }

    private void visitExprHolderHelper(SoyNode.ExprHolderNode exprHolderNode) {
        for (ExprRootNode<? extends ExprNode> exprRootNode : exprHolderNode.getAllExprs()) {
            if (this.currFileHasOptParams && !this.usesFunctionHasData && ((Boolean)new UsesFunctionHasDataVisitor().exec(exprRootNode)).booleanValue()) {
                this.usesFunctionHasData = true;
            }
            this.getDataKeysInExprVisitor.exec(exprRootNode);
        }
    }

    private static class GetDataKeysInExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final Set<String> dataKeys;
        private final Deque<Set<String>> localVarFrames;

        public GetDataKeysInExprVisitor(Set<String> set, Deque<Set<String>> deque) {
            this.dataKeys = set;
            this.localVarFrames = deque;
        }

        @Override
        protected void visitInternal(DataRefNode dataRefNode) {
            String string = ((DataRefKeyNode)dataRefNode.getChild(0)).getKey();
            boolean bl = false;
            for (Set<String> set : this.localVarFrames) {
                if (!set.contains(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.dataKeys.add(string);
            }
            this.visitChildren(dataRefNode);
        }

        @Override
        protected void visitInternal(ExprNode exprNode) {
        }

        @Override
        protected void visitInternal(ExprNode.ParentExprNode parentExprNode) {
            this.visitChildren(parentExprNode);
        }
    }

    private static class UsesFunctionHasDataVisitor
    extends AbstractExprNodeVisitor<Boolean> {
        private boolean usesFunctionHasData;

        private UsesFunctionHasDataVisitor() {
        }

        @Override
        protected void setup() {
            this.usesFunctionHasData = false;
        }

        @Override
        protected Boolean getResult() {
            return this.usesFunctionHasData;
        }

        @Override
        protected void visitInternal(FunctionNode functionNode) {
            if (functionNode.getFunctionName().equals("hasData")) {
                this.usesFunctionHasData = true;
            }
        }

        @Override
        protected void visitInternal(ExprNode exprNode) {
        }

        @Override
        protected void visitInternal(ExprNode.ParentExprNode parentExprNode) {
            for (ExprNode exprNode : parentExprNode.getChildren()) {
                if (this.usesFunctionHasData) {
                    return;
                }
                this.visit(exprNode);
            }
        }
    }
}

