/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses;

import com.google.common.collect.Lists;
import com.google.template.soy.base.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.List;

public class CombineConsecutiveRawTextNodesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private IdGenerator nodeIdGen;

    @Override
    public Void exec(SoyNode soyNode) {
        this.nodeIdGen = soyNode.getNearestAncestor(SoyFileSetNode.class).getNodeIdGen();
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitInternal(SoyNode soyNode) {
    }

    @Override
    protected void visitInternal(SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode) {
        this.visitChildren(parentSoyNode);
        boolean bl = false;
        for (int i = 0; i <= parentSoyNode.numChildren() - 2; ++i) {
            if (!(parentSoyNode.getChild(i) instanceof RawTextNode) || !(parentSoyNode.getChild(i + 1) instanceof RawTextNode)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        SoyNode.ParentSoyNode<? extends SoyNode> parentSoyNode2 = parentSoyNode;
        List list = parentSoyNode2.getChildren();
        parentSoyNode2.clearChildren();
        ArrayList arrayList = Lists.newArrayList();
        for (SoyNode soyNode : list) {
            if (soyNode instanceof RawTextNode) {
                arrayList.add((RawTextNode)soyNode);
                continue;
            }
            this.addConsecutiveRawTextNodesAsOneNodeHelper(parentSoyNode2, arrayList);
            arrayList.clear();
            parentSoyNode2.addChild(soyNode);
        }
        this.addConsecutiveRawTextNodesAsOneNodeHelper(parentSoyNode2, arrayList);
        arrayList.clear();
    }

    private void addConsecutiveRawTextNodesAsOneNodeHelper(SoyNode.ParentSoyNode<? super RawTextNode> parentSoyNode, List<RawTextNode> list) {
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            parentSoyNode.addChild((RawTextNode)((Node)list.get(0)));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (RawTextNode rawTextNode : list) {
                stringBuilder.append(rawTextNode.getRawText());
            }
            parentSoyNode.addChild(new RawTextNode(this.nodeIdGen.genStringId(), stringBuilder.toString()));
        }
    }
}

